/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Resize;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class ImageClass {
    public static final ElementClass INSTANCE = ElementClass.compile(ImageElementHandler.INSTANCE, DefaultTransform.INSTANCE);

    public static class ImageElementHandler
    implements SceneGraph,
    InternalSize,
    Resize,
    Outline {
        private static final long serialVersionUID = 7980198654721917029L;
        public static final ImageElementHandler INSTANCE = new ImageElementHandler();
        public static final IHintContext.Key KEY_SG_NODE = new SceneGraphNodeKey(Node.class, "IMAGE_SG_NODE");

        protected Image getImage(IElement e) {
            Image i = (Image)e.getHint(ElementHints.KEY_IMAGE);
            if (i == null) {
                throw new IllegalStateException("element " + String.valueOf(e) + " has no ElementHints.KEY_IMAGE hint");
            }
            return i;
        }

        protected IHintContext.Key getNodeKey() {
            return KEY_SG_NODE;
        }

        @Override
        public void init(IElement e, G2DParentNode parent) {
            Image i = this.getImage(e);
            Node node = i.init(parent);
            if (node != null) {
                e.setHint(this.getNodeKey(), node);
            }
            if (node instanceof IG2DNode) {
                IG2DNode n = (IG2DNode)node;
                AffineTransform at = ElementUtils.getTransform(e);
                if (at != null) {
                    n.setTransform(at);
                }
            }
        }

        @Override
        public void cleanup(IElement e) {
            Node node = (Node)e.removeHint(this.getNodeKey());
            if (node != null) {
                node.remove();
            }
        }

        @Override
        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            Image i = this.getImage(e);
            Rectangle2D r = i.getBounds();
            if (size == null) {
                size = new Rectangle2D.Double();
            }
            size.setFrame(r);
            return size;
        }

        @Override
        public Double getFixedAspectRatio(IElement e) {
            Image i = this.getImage(e);
            Rectangle2D r = i.getBounds();
            return r.getWidth() / r.getHeight();
        }

        @Override
        public Rectangle2D getMaximumSize(IElement e) {
            Image i = this.getImage(e);
            return i.getBounds();
        }

        @Override
        public Rectangle2D getMinimumSize(IElement e) {
            Image i = this.getImage(e);
            return i.getBounds();
        }

        @Override
        public void resize(IElement e, Rectangle2D newSize) {
        }

        @Override
        public Shape getElementShape(IElement e) {
            Image i = this.getImage(e);
            return i.getOutline();
        }
    }

    public static class StaticImageElementHandler
    extends ImageElementHandler {
        private static final long serialVersionUID = 7691329107125520049L;
        public static final IHintContext.Key KEY_SG_NODE = new SceneGraphNodeKey(Node.class, "STATIC_IMAGE_SG_NODE");
        private final Image i;

        public StaticImageElementHandler(Image i) {
            this.i = i;
        }

        @Override
        protected Image getImage(IElement e) {
            return this.i;
        }

        @Override
        protected IHintContext.Key getNodeKey() {
            return KEY_SG_NODE;
        }
    }
}

