/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IMouseCaptureHandle;
import org.simantics.g2d.diagram.participant.DiagramParticipant;
import org.simantics.g2d.diagram.participant.ElementInteractor;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.HandleMouseEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.utils.datastructures.hints.IHintContext;

public abstract class AbstractGrabbable
implements HandleMouseEvent {
    private static final long serialVersionUID = -3620527648364111724L;
    Double strayDistance;
    protected int grabMouseButton = 1;

    public AbstractGrabbable(Double strayDistance) {
        this.strayDistance = strayDistance;
    }

    public AbstractGrabbable() {
        this.strayDistance = 1000.0;
    }

    @Override
    public boolean handleMouseEvent(IElement e, ICanvasContext ctx, MouseEvent me) {
        int pointerId = me.mouseId;
        GrabInfo gi = this.getGrabInfo(e, ctx, pointerId);
        if (me instanceof MouseEvent.MouseClickEvent || me instanceof MouseEvent.MouseDragBegin) {
            return gi != null;
        }
        if (me instanceof MouseEvent.MouseMovedEvent) {
            MouseEvent.MouseMovedEvent mme = (MouseEvent.MouseMovedEvent)me;
            if (gi == null) {
                return false;
            }
            gi.prevPosCanvas.setLocation(gi.dragPosCanvas);
            gi.prevPosControl.setLocation(gi.dragPosControl);
            gi.prevPosElement.setLocation(gi.dragPosElement);
            gi.dragPosControl.setLocation(me.controlPosition);
            ElementUtils.controlToCanvasCoordinate(ctx, mme.controlPosition, gi.dragPosCanvas);
            ElementUtils.controlToElementCoordinate(e, ctx, mme.controlPosition, gi.dragPosElement);
            double dist = gi.dragPosControl.distance(gi.grabPosControl);
            if (dist > this.strayDistance) {
                this.releaseGrab(e, ctx, pointerId);
                this.onGrabCancel(gi, ctx);
                return true;
            }
            this.onDrag(gi, ctx);
            return true;
        }
        if (me instanceof MouseEvent.MouseButtonReleasedEvent) {
            MouseEvent.MouseButtonEvent mbe = (MouseEvent.MouseButtonEvent)me;
            if (mbe.button != this.grabMouseButton) {
                return false;
            }
            if (gi == null) {
                return false;
            }
            this.releaseGrab(e, ctx, pointerId);
            this.onRelease(gi, ctx);
            return true;
        }
        if (me instanceof MouseEvent.MouseButtonPressedEvent) {
            MouseEvent.MouseButtonEvent mbe = (MouseEvent.MouseButtonEvent)me;
            if (mbe.button != this.grabMouseButton) {
                return false;
            }
            if (!this.onGrabCheck(e, ctx, pointerId, me.controlPosition)) {
                return false;
            }
            gi = this.grabMouse(e, ctx, pointerId, me.controlPosition);
            this.onGrab(gi, ctx);
            return true;
        }
        return false;
    }

    protected abstract boolean onGrabCheck(IElement var1, ICanvasContext var2, int var3, Point2D var4);

    protected abstract void onGrab(GrabInfo var1, ICanvasContext var2);

    protected abstract void onRelease(GrabInfo var1, ICanvasContext var2);

    protected abstract void onDrag(GrabInfo var1, ICanvasContext var2);

    protected abstract void onGrabCancel(GrabInfo var1, ICanvasContext var2);

    protected void cancelGrab() {
    }

    private void removeGrabInfo(IElement e, ICanvasContext ctx, int pointerId) {
        DiagramParticipant dp = (DiagramParticipant)ctx.getSingleItem(DiagramParticipant.class);
        IHintContext.MouseSpecificKeyOf key = new IHintContext.MouseSpecificKeyOf(pointerId, GrabInfo.class);
        dp.removeElementHint(e, (IHintContext.Key)key);
    }

    private void setGrabInfo(IElement e, ICanvasContext ctx, int pointerId, GrabInfo gi) {
        DiagramParticipant dp = (DiagramParticipant)ctx.getSingleItem(DiagramParticipant.class);
        IHintContext.MouseSpecificKeyOf key = new IHintContext.MouseSpecificKeyOf(pointerId, GrabInfo.class);
        dp.setElementHint(e, (IHintContext.Key)key, gi);
    }

    private GrabInfo getGrabInfo(IElement e, ICanvasContext ctx, int pointerId) {
        DiagramParticipant dp = (DiagramParticipant)ctx.getSingleItem(DiagramParticipant.class);
        IHintContext.MouseSpecificKeyOf key = new IHintContext.MouseSpecificKeyOf(pointerId, GrabInfo.class);
        return (GrabInfo)dp.getElementHint(e, (IHintContext.Key)key);
    }

    protected Map<Integer, GrabInfo> getGrabs(IElement e, ICanvasContext ctx) {
        DiagramParticipant dp = (DiagramParticipant)ctx.getSingleItem(DiagramParticipant.class);
        Map<IHintContext.Key, Object> map = dp.getElementHints(e);
        if (map == null) {
            return null;
        }
        HashMap<Integer, GrabInfo> result = new HashMap<Integer, GrabInfo>();
        for (Map.Entry<IHintContext.Key, Object> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof GrabInfo)) continue;
            GrabInfo gi = (GrabInfo)entry.getValue();
            result.put(gi.pointerId, gi);
        }
        return result;
    }

    protected int getGrabCount(IElement e, ICanvasContext ctx) {
        DiagramParticipant dp = (DiagramParticipant)ctx.getSingleItem(DiagramParticipant.class);
        Map<IHintContext.Key, Object> map = dp.getElementHints(e);
        if (map == null) {
            return 0;
        }
        int result = 0;
        for (Map.Entry<IHintContext.Key, Object> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof GrabInfo)) continue;
            ++result;
        }
        return result;
    }

    protected void releaseGrab(IElement e, ICanvasContext ctx, int pointerId) {
        GrabInfo gi = this.getGrabInfo(e, ctx, pointerId);
        if (gi == null) {
            return;
        }
        gi.hnd.release();
        this.removeGrabInfo(e, ctx, pointerId);
    }

    private GrabInfo grabMouse(IElement e, ICanvasContext ctx, int pointerId, Point2D grabPointControl) {
        this.releaseGrab(e, ctx, pointerId);
        ElementInteractor ei = (ElementInteractor)ctx.getSingleItem(ElementInteractor.class);
        IMouseCaptureHandle hnd = ei.captureMouse(e, pointerId);
        if (hnd == null) {
            return null;
        }
        Point2D grabPointCanvas = ElementUtils.controlToCanvasCoordinate(ctx, grabPointControl, new Point2D.Double());
        Point2D grabPointElement = ElementUtils.controlToElementCoordinate(e, ctx, grabPointControl, new Point2D.Double());
        GrabInfo gi = new GrabInfo();
        gi.e = e;
        gi.hnd = hnd;
        gi.pointerId = pointerId;
        gi.grabPosControl.setLocation(grabPointControl);
        gi.grabPosCanvas.setLocation(grabPointCanvas);
        gi.grabPosElement.setLocation(grabPointElement);
        gi.dragPosControl.setLocation(grabPointControl);
        gi.dragPosCanvas.setLocation(grabPointCanvas);
        gi.dragPosElement.setLocation(grabPointElement);
        gi.prevPosControl.setLocation(grabPointControl);
        gi.prevPosCanvas.setLocation(grabPointCanvas);
        gi.prevPosElement.setLocation(grabPointElement);
        this.setGrabInfo(e, ctx, pointerId, gi);
        return gi;
    }

    public static class GrabInfo {
        public IElement e;
        public int pointerId;
        public Point2D grabPosControl = new Point2D.Double();
        public Point2D grabPosCanvas = new Point2D.Double();
        public Point2D grabPosElement = new Point2D.Double();
        public Point2D dragPosControl = new Point2D.Double();
        public Point2D dragPosCanvas = new Point2D.Double();
        public Point2D dragPosElement = new Point2D.Double();
        public Point2D prevPosControl = new Point2D.Double();
        public Point2D prevPosCanvas = new Point2D.Double();
        public Point2D prevPosElement = new Point2D.Double();
        private IMouseCaptureHandle hnd;
    }
}

