/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.handler.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.LifeCycle;
import org.simantics.g2d.diagram.handler.TransactionContext;
import org.simantics.g2d.element.IElement;
import org.simantics.utils.datastructures.ListenerList;

public class TransactionContextImpl
implements TransactionContext,
LifeCycle {
    Map<IDiagram, ListenerList<TransactionContext.TransactionListener>> list = new HashMap<IDiagram, ListenerList<TransactionContext.TransactionListener>>();

    @Override
    public void addTransactionListener(IDiagram d, TransactionContext.TransactionListener l) {
        ListenerList ll = this.list.get(d);
        if (ll == null) {
            ll = new ListenerList(TransactionContext.TransactionListener.class);
            this.list.put(d, (ListenerList<TransactionContext.TransactionListener>)ll);
        }
        ll.add((Object)l);
    }

    @Override
    public void removeTransactionListener(IDiagram d, TransactionContext.TransactionListener l) {
        ListenerList<TransactionContext.TransactionListener> ll = this.list.get(d);
        if (ll == null) {
            return;
        }
        ll.remove((Object)l);
    }

    @Override
    public void onDiagramDestroyed(IDiagram diagram) {
    }

    @Override
    public void onDiagramDisposed(IDiagram diagram) {
        this.list.remove(diagram);
    }

    @Override
    public void onDiagramCreated(IDiagram diagram) {
    }

    @Override
    public void onDiagramLoaded(IDiagram diagram, Collection<IElement> initialElements) {
    }

    @Override
    public TransactionContext.Transaction startTransaction(IDiagram d, TransactionContext.TransactionType type) {
        TransactionContext.Transaction.Impl t = new TransactionContext.Transaction.Impl(type);
        ListenerList<TransactionContext.TransactionListener> ll = this.list.get(d);
        if (ll != null) {
            TransactionContext.TransactionListener[] transactionListenerArray = (TransactionContext.TransactionListener[])ll.getListeners();
            int n = transactionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransactionContext.TransactionListener l = transactionListenerArray[n2];
                l.transactionStarted(d, t);
                ++n2;
            }
        }
        return t;
    }

    @Override
    public void finishTransaction(IDiagram d, TransactionContext.Transaction t) {
        ListenerList<TransactionContext.TransactionListener> ll = this.list.get(d);
        if (ll == null) {
            return;
        }
        TransactionContext.TransactionListener[] transactionListenerArray = (TransactionContext.TransactionListener[])ll.getListeners();
        int n = transactionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransactionContext.TransactionListener l = transactionListenerArray[n2];
            l.transactionFinished(d, t);
            ++n2;
        }
    }
}

