/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.chassis;

import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JFrame;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.chassis.AWTChassis;
import org.simantics.g2d.participant.KeyToCommand;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.CommandKeyBinding;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.utils.datastructures.cache.IProvider;

public class FullscreenUtils {
    public static Frame viewFullScreen(GraphicsDevice monitor, ICanvasContext ctx) {
        DisplayMode dm = monitor.getDisplayMode();
        final JFrame frame = new JFrame("Fullscreen mode");
        frame.setSize(dm.getWidth(), dm.getHeight());
        frame.setUndecorated(true);
        AWTChassis chassis = new AWTChassis();
        chassis.setOpaque(true);
        chassis.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    frame.dispose();
                }
            }
        });
        frame.getContentPane().add((Component)chassis, "Center");
        frame.pack();
        frame.invalidate();
        Rectangle awtBounds = monitor.getDefaultConfiguration().getBounds();
        frame.setBounds(awtBounds);
        frame.setAlwaysOnTop(true);
        frame.setVisible(true);
        chassis.setCanvasContext(ctx);
        return frame;
    }

    public static void addFullScreenHandler(ICanvasContext ctx, final Shell shell, final IProvider<ICanvasContext> fullscreenProvider) {
        KeyToCommand commands = (KeyToCommand)ctx.getAtMostOneItemOfClass(KeyToCommand.class);
        if (commands == null) {
            commands = new KeyToCommand(new CommandKeyBinding[0]);
            ctx.add(commands);
        }
        commands.addBinding(new CommandKeyBinding(Commands.FULL_SCREEN, "View in full screen mode", new int[]{10, 17}));
        ctx.add(new AbstractCanvasParticipant(){

            @EventHandlerReflection.EventHandler(priority=0)
            public boolean handleEvent(CommandEvent e) {
                this.assertDependencies();
                Command c = e.command;
                if (c.equals((Object)Commands.FULL_SCREEN)) {
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            GraphicsDevice gd = FullscreenUtils.getOrQueryDisplay(shell);
                            if (gd != null) {
                                FullscreenUtils.viewFullScreen(gd, (ICanvasContext)fullscreenProvider.get());
                            }
                        }
                    });
                    return true;
                }
                return false;
            }
        });
    }

    public static GraphicsDevice getOrQueryDisplay(Shell shell) {
        GraphicsDevice[] list = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (list.length == 0) {
            return null;
        }
        if (list.length == 1) {
            return list[0];
        }
        return FullscreenUtils.doDisplayDialog(shell);
    }

    public static GraphicsDevice doDisplayDialog(Shell shell) {
        ListDialog ld = new ListDialog(shell);
        ld.setInput((Object)GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices());
        ld.setTitle("Select display device");
        ld.setInitialSelections(new Object[]{GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice()});
        ld.setMessage("Select display device");
        ld.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        ld.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                GraphicsDevice gd = (GraphicsDevice)element;
                return gd.getIDstring() + " (" + gd.getDisplayMode().getWidth() + "*" + gd.getDisplayMode().getHeight() + ")";
            }
        });
        ld.setBlockOnOpen(true);
        if (ld.open() != 0) {
            return null;
        }
        return (GraphicsDevice)ld.getResult()[0];
    }

    private static void addCloseHandler(ICanvasContext ctx, final Frame frame) {
        KeyToCommand commands = (KeyToCommand)ctx.getAtMostOneItemOfClass(KeyToCommand.class);
        if (commands == null) {
            commands = new KeyToCommand(new CommandKeyBinding[0]);
            ctx.add(commands);
        }
        commands.addBinding(new CommandKeyBinding(Commands.CLOSE, "Close Canvas", new int[]{27}));
        ctx.add(new AbstractCanvasParticipant(){

            @EventHandlerReflection.EventHandler(priority=0)
            public boolean handleEvent(CommandEvent e) {
                this.assertDependencies();
                frame.dispose();
                return true;
            }
        });
    }

    public static Monitor getMonitor(Shell shell) {
        Monitor result = null;
        long largestArea = 0L;
        org.eclipse.swt.graphics.Rectangle shellRectangle = shell.getBounds();
        Monitor[] monitorArray = Display.getCurrent().getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor monitor = monitorArray[n2];
            org.eclipse.swt.graphics.Rectangle monitorBounds = monitor.getBounds();
            org.eclipse.swt.graphics.Rectangle intersection = monitorBounds.intersection(shellRectangle);
            long area = intersection.width * intersection.height;
            if (area > largestArea) {
                largestArea = area;
                result = monitor;
            }
            ++n2;
        }
        return result;
    }

    public static GraphicsDevice getMonitorCorrespondence(Monitor swtMonitor) {
        org.eclipse.swt.graphics.Rectangle swtBounds = swtMonitor.getBounds();
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice gd = graphicsDeviceArray[n2];
            if (gd.getType() == 0) {
                Rectangle awtBounds = gd.getDefaultConfiguration().getBounds();
                if (awtBounds.x == swtBounds.x && awtBounds.y == swtBounds.y && awtBounds.width == swtBounds.width && awtBounds.height == swtBounds.height) {
                    return gd;
                }
            }
            ++n2;
        }
        return null;
    }
}

