/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.tooltip;


import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.g2d.element.IElement;

public abstract class EditableTextTooltipProvider2 implements FocusableTooltipProvider {
	
	private Shell shell;
	private Text text;
	
	@Override
	public void showTooltip(final IElement element, final int x, final int y) {
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				if (shell != null) {
					shell.dispose();
					shell = null;
				}
				shell = new Shell(Display.getCurrent().getActiveShell(),SWT.NO_TRIM);
				shell.setLayout(new FillLayout());
				Composite composite = new Composite(shell, SWT.BORDER);
				composite.setLayout(new FillLayout(SWT.VERTICAL));
				Label label = new Label(composite,SWT.NONE);
				label.setText("Press 'F9' to focus");
				text = new Text(composite, SWT.SINGLE);
				text.setText(getTooltipText(element));
				text.addKeyListener(new KeyAdapter() {
					@Override
					public void keyReleased(KeyEvent e) {
						if (e.keyCode == SWT.CR) {
							setText(element, text.getText());
							shell.dispose();
							shell = null;
						}
					}
				});
				shell.pack();
				shell.setVisible(true);
				shell.setLocation(x, y-32);
				
			}
		});
		
	}
	
	@Override
	public void hideTooltip(IElement element) {
		if (shell == null)
			return;
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				shell.dispose();
				shell = null;

			}
		});
	}
	
	public void focus() {
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				if (!shell.isDisposed())
					shell.forceFocus();
			}
		});
	}
	boolean has_focus = false;
	
	@Override
	public boolean hasFocus() {
		
		Display.getDefault().syncExec(new Runnable() {
			
			@Override
			public void run() {
				if(shell != null && !shell.isDisposed())
					has_focus = shell.isFocusControl() || text.isFocusControl();
				
				else
					has_focus = false;
				
			}
		});
		return has_focus;
	}
	
	public abstract String getTooltipText(IElement element);
	
	public abstract void setText(IElement element, String text);

}
