/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.routing.algorithm2;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

import org.simantics.g2d.routing.Constants;
import org.simantics.g2d.routing.IGraphModel;
import org.simantics.g2d.routing.IRouter;
import org.simantics.g2d.routing.Terminal;

public class Router2 implements IRouter {

    static int getSomeDirection(int mask) {
        if(mask == 0)
            return 0;
        int result = 0;
        while((mask & 1) == 0) {
            ++result;
            mask >>= 1;
        }
        return result;
    }
    
    @Override
    public void update(IGraphModel model) {
        LocalRouter localRouter = new LocalRouter(false);
        for(Object c : model.getConnections()) {
            Terminal begin = model.getBeginTerminal(c);        
            Terminal end = model.getEndTerminal(c);
            double[] points = model.getRoutePoints(c);
            
            if(begin == null) {
            	if(points.length < 2)
            		continue;
    			begin = new Terminal(points[0], points[1], 0x1, Terminal.ZEROS, 
    				new Rectangle2D.Double(points[0], points[1], 0.0, 0.0));
    			points = Arrays.copyOfRange(points, 2, points.length);
    		}
    		if(end == null) {
    			if(points.length < 2)
            		continue;
    			end = new Terminal(points[points.length-2], points[points.length-1], 0xf, Terminal.ZEROS,
    				new Rectangle2D.Double(points[points.length-2], points[points.length-1], 0.0, 0.0));
    			points = Arrays.copyOf(points, points.length-2);
    		}

    		double bestLength = Double.POSITIVE_INFINITY;
    		Path2D bestPath = null;
    		
    		for(int sDir : Constants.POSSIBLE_DIRECTIONS[begin.directions])
    			for(int tDir : Constants.POSSIBLE_DIRECTIONS[end.directions]) {
    				localRouter.sx = begin.x;
    				localRouter.sy = begin.y;
    				localRouter.aMinX = begin.parentObstacle.getMinX();
    				localRouter.aMinY = begin.parentObstacle.getMinY();
    				localRouter.aMaxX = begin.parentObstacle.getMaxX();
    				localRouter.aMaxY = begin.parentObstacle.getMaxY();
    				localRouter.sourceDirection = sDir;

    				localRouter.tx = end.x;
    				localRouter.ty = end.y;
    				localRouter.bMinX = end.parentObstacle.getMinX();
    				localRouter.bMinY = end.parentObstacle.getMinY();
    				localRouter.bMaxX = end.parentObstacle.getMaxX();
    				localRouter.bMaxY = end.parentObstacle.getMaxY();
    				localRouter.targetDirection = tDir;

    				localRouter.route();

    				double length = pathLength(localRouter.path);
    				if(length < bestLength) {
    					bestLength = length;
    					bestPath = localRouter.path;
    				}  
    			}
            
    		if(bestPath != null)
    			model.setPath(c, bestPath);
        }
    }
    
    final static AffineTransform IDENTITY = new AffineTransform();

    static double pathLength(Path2D path) {
    	double length = 0.0;
    	PathIterator it = path.getPathIterator(IDENTITY);
    	double[] temp = new double[6];
    	double x=0.0, y=0.0;
    	double bendCount = 0.0;
    	while(!it.isDone()) {
    		bendCount += 1.0;
    		if(it.currentSegment(temp) != PathIterator.SEG_MOVETO)
    			length += Math.abs(x - temp[0] + y - temp[1]);
    		x = temp[0];
			y = temp[1];
			it.next();
    	}
    	return length * (6.0 + bendCount);
    }
    
}
