/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.participant;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection.Dependency;
import org.simantics.g2d.participant.CanvasGrab.PointerInfo;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection.EventHandler;
import org.simantics.scenegraph.g2d.events.MouseEvent.MouseButtonPressedEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent.MouseButtonReleasedEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent.MouseExitEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent.MouseMovedEvent;

/**
 * @author Toni Kalajainen
 */
public class MultitouchPanZoomRotateInteractor extends AbstractCanvasParticipant {

	@Dependency TransformUtil util;
	@Dependency CanvasGrab grab;
    
    // Pointer grabbing button
    public static final int BUTTON_ID = 1;
    
    @EventHandler(priority = Integer.MAX_VALUE - 2000)
    public boolean handleEvent(MouseButtonPressedEvent e) {
        // ignore normal mouse        
		if (getHint(Hints.KEY_TOOL) != Hints.PANTOOL) return false;
        if (e.mouseId==0) return false;
        if (e.button != BUTTON_ID) return false;
    	assertDependencies();
        //System.out.println(e.mouseId+" down");
        Point2D controlPos = e.controlPosition;
        Point2D canvasPos = util.controlToCanvas(controlPos, null);
        grab.grabCanvas(e.mouseId, canvasPos); 
        return false;
    }
    
    @EventHandler(priority = Integer.MAX_VALUE - 2000)
    public boolean handleEvent(MouseButtonReleasedEvent e) {
        // ignore normal mouse
		if (getHint(Hints.KEY_TOOL) != Hints.PANTOOL) return false;
        if (e.mouseId==0) return false;
        if (e.button != BUTTON_ID) return false;
    	assertDependencies();
        //System.out.println(e.mouseId+" up");
        grab.grabInfo.remove(e.mouseId);
        
        return false;
    }
    
    @EventHandler(priority = Integer.MAX_VALUE - 2000)
    public boolean handleEvent(MouseExitEvent e) {
        // ignore normal mouse
		if (getHint(Hints.KEY_TOOL) != Hints.PANTOOL) return false;
        if (e.mouseId==0) return false;
    	assertDependencies();
        //System.out.println(e.mouseId+" exit");
        grab.grabInfo.remove(e.mouseId);        
        return false;
    }    	
	
    @EventHandler(priority = Integer.MAX_VALUE - 2000)
    public boolean handleEvent(MouseMovedEvent e) {   
    	if (e.context instanceof MouseUtil) return false;
		if (getHint(Hints.KEY_TOOL) != Hints.PANTOOL) return false;
    	assertDependencies();
        PointerInfo ai = grab.grabInfo.get(e.mouseId);
        if (ai==null) return false;
        if (grab.grabInfo.size() == 1) {
            PointerInfo pi = grab.grabInfo.values().iterator().next();            

            Point2D pt = util.controlToCanvas(e.controlPosition, null);
            
            double	a1_x = pi.anchorPos.getX();
            double 	a1_y = pi.anchorPos.getY();
            double 	b1_x = pt.getX();
            double	b1_y = pt.getY();
     		
            AffineTransform gat = util.getTransform();
            gat.translate(b1_x-a1_x, b1_y-a1_y);
            util.setTransform(gat);
			
            return true; // TODO Do panning;
        }        
        if (grab.grabInfo.size()!=2) return false;
        
        double	EPSILON = 3;
 
        PointerInfo[] pi = grab.grabInfo.values().toArray(new PointerInfo[2]);
        
        for (PointerInfo p : pi)
        	if (p.mouseId == e.mouseId)
        		p.currentPos = util.controlToCanvas(e.controlPosition, null);

        double	a1_x = pi[0].anchorPos.getX();
        double 	a1_y = pi[0].anchorPos.getY();
        double 	b1_x = pi[0].currentPos.getX();
        double	b1_y = pi[0].currentPos.getY();
        
        double  a2_x = pi[1].anchorPos.getX();
        double  a2_y = pi[1].anchorPos.getY();
        double 	b2_x = pi[1].currentPos.getX();
        double	b2_y = pi[1].currentPos.getY();        

        for (PointerInfo p : pi)
        	if (p.mouseId != e.mouseId)
        		p.currentPos = p.anchorPos;

        double 	da_x = a1_x - a2_x;
        double	da_y = a1_y - a2_y;
        double 	da_lensq = da_x*da_x + da_y*da_y;
        if(da_lensq < EPSILON) {
        	System.err.println("a1 ja a2 ovat liian lhell toisiaan");
        	return false;
        }

        double 	db_x = b1_x - b2_x;
        double	db_y = b1_y - b2_y;
        
        double s_x = (db_x * da_x + db_y * da_y) / da_lensq;
        double s_y = (-db_x * da_y + db_y * da_x) / da_lensq;
        
        double t_x = b1_x - s_x * a1_x + s_y * a1_y;
        double t_y = b1_y - s_x * a1_y - s_y * a1_x;
        
        double mat[] = new double[] {s_x, s_y, -s_y, s_x, t_x, t_y};
        AffineTransform at = new AffineTransform(mat);
		setDirty();
        
        AffineTransform gat = util.getTransform();
        gat.concatenate(at);
        util.setTransform(gat);
        
        return true;
    }
   	
	
}
