/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.internal;

import org.eclipse.core.runtime.Platform;


/**
 * @author Tuukka Lehtonen
 */
public final class DebugPolicy {

    public static boolean DEBUG                                 = false;

    public static boolean DEBUG_DELAYED_ELEMENT_PAINTER         = false;
    public static boolean DEBUG_DELAYED_ELEMENT_PAINTER_MARKING = false;

    public static boolean PERF_CHASSIS_RENDER_FRAME         = false;

    static {
    	Activator activator = Activator.getDefault();
        if (activator != null && activator.isDebugging()) {
            DEBUG = true;
            String sTrue = Boolean.TRUE.toString();

            DEBUG_DELAYED_ELEMENT_PAINTER = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/element/painter/delayed")); //$NON-NLS-1$
            DEBUG_DELAYED_ELEMENT_PAINTER_MARKING = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/element/painter/delayed/marking")); //$NON-NLS-1$

            PERF_CHASSIS_RENDER_FRAME = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/perf/chassis/renderFrame")); //$NON-NLS-1$
        }
    }

}
