/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.gallery;

import java.awt.Font;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.ElementClass.Single;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.GalleryItemNode;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

@Single
public class GalleryItemSGNode implements SceneGraph, LifeCycle {

    private static final long serialVersionUID = 6625834518019163965L;

    public final static Key   KEY_IMAGE                 = new KeyOf(Image.class, "GALLERY_IMAGE");
    public final static Key   KEY_IMAGE_SHADOW          = new KeyOf(Image.class, "GALLERY_IMAGE_SHADOW");
    public final static Key   KEY_TARGET_IMAGE_SIZE     = new KeyOf(Point.class, "GALLERY_TARGET_IMAGE_SIZE");

    public final static Point DEFAULT_TARGET_IMAGE_SIZE = new Point(50, 50);

    public static final Key   KEY_GALLERY_ITEM_NODE     = new SceneGraphNodeKey(GalleryItemNode.class, "GALLERY_ITEM_NODE");

    private Font              font;

    public static Image getImage(IElement e) {
        return e.getHint(KEY_IMAGE);
    }

    public GalleryItemSGNode(Font font) {
        this.font = font;
    }

    public void update(IElement e) {
        GalleryItemNode node = (GalleryItemNode) e.getHint(KEY_GALLERY_ITEM_NODE);
        if (node != null) {
            Rectangle2D bounds = ElementUtils.getElementBounds(e);
            String str = ElementUtils.getText(e);
            Image img = e.getHint(KEY_IMAGE);

            Rectangle2D imageBounds = img.getBounds();
            node.init(str, bounds, font, imageBounds);

            AffineTransform at = e.getElementClass().getSingleItem(Transform.class).getTransform(e);
            node.setTransform((AffineTransform) at.clone());

            img.init(node);
        }
    }

    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public void init(final IElement e, G2DParentNode parent) {
        GalleryItemNode node = (GalleryItemNode) e.getHint(KEY_GALLERY_ITEM_NODE);
        if (node == null) {
            node = parent.addNode(GalleryItemNode.class);
            e.setHint(KEY_GALLERY_ITEM_NODE, node);
        }
        update(e);
    }

    @Override
    public void cleanup(IElement e) {
        Node node = e.removeHint(KEY_GALLERY_ITEM_NODE);
        if (node != null)
            node.remove();
    }

    @Override
    public void onElementActivated(IDiagram d, IElement e) {
    }

    @Override
    public void onElementCreated(IElement e) {
    }

    @Override
    public void onElementDeactivated(IDiagram d, IElement e) {
    }

    @Override
    public void onElementDestroyed(IElement e) {
        cleanup(e);
    }

}
