/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import java.awt.Shape;

import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.PickRequest.PickPolicy;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Pick;

/**
 * @author Toni Kalajainen
 */
public class ProxyPick implements Pick {

    private static final long serialVersionUID = 7045385767576576902L;

    Pick orig;
    IProxyProvider provider;

    public ProxyPick(IProxyProvider provider, Pick orig) {
        this.provider = provider;
        this.orig = orig;
    }

    @Override
    public boolean pickTest(IElement e, Shape s, PickPolicy policy) {
        return orig.pickTest(e, s, policy);
    }

    @Override
    public boolean pickTest(IElement e, PickRequest req) {
        return orig.pickTest(e, req);
    }

}
