/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import java.awt.Shape;

import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.PickRequest.PickPolicy;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.utils.GeometryUtils;


/**
 * Pick-interface allows detailed pick test for an element.
 * If pick is not implemented, its ({@link Outline}) is used for pick test.
 * If outline is not implemented, its bounds is used for pick.
 * 
 * @See {@link InternalSize}
 * @See {@link BoundsPickable}
 * @See {@link GeometryUtils}
 * 
 * @author Toni Kalajainen
 */
public interface Pick extends ElementHandler {

    /**
     * Make pick test
     * @param e the element to pick test
     * @param s the picking shape to test against e, in canvas coordinate system
     * @param policy the criterion for picking acceptance
     * @return <code>true</code> if shape intersects/contains element e, otherwise <code>false</code>
     */
    default boolean pickTest(IElement e, Shape s, PickPolicy policy) {
        return false;
    }

    /**
     * Make pick test
     * @param e the element to pick test
     * @param req the picking request containing the pick area, pick policy and other mode information
     * @return <code>true</code> if shape intersects/contains element e, otherwise <code>false</code>
     */
    default boolean pickTest(IElement e, PickRequest req) {
        return pickTest(e, req.pickArea, req.pickPolicy);
    }

}
