/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.List;

import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.ElementClass.Single;

/**
 * Interface for adapting editing edge bends between information models.
 * 
 * Bend is a control point of an edge. The path of an edge follows thru all its 
 * edges.  
 * 
 * @see Topology 
 * @author Toni Kalajainen
 */
@Single
public interface BendsHandler extends ElementHandler { 

	/** Information for painter */
	public static enum AngleType { 
		Line,				/* Straight from begin to end */ 
		RightAngled, 		/* 90-degree angles */
		Linear, 			/* 1st degree lines, free angles */
		Quadratic 			/* 3rd degree line segments */
		// FIXME: 2nd, not 3rd degree ?
	}
	AngleType getAngleType(IElement e);
	void setAngleType(IElement e, AngleType angleType);
	
	public interface Bend {}
	
	/**
	 * Get bends
	 * @param e
	 * @param bends collection to be filled with bends
	 */
	void getBends(IElement e, List<Bend> bends);
	
	
	/**
	 * Get bend position in element coordinate system
	 * 
	 * @param e
	 * @param b
	 * @param pos point object to be filled with the position (not null) 
	 * @return point object pos 
	 */
	void getBendPosition(IElement e, Bend b, Point2D pos);
	
	/**
	 * Add bend
	 * @param e
	 * @param index
	 * @param pos element coordinate system position
	 * @return
	 */
	Bend addBend(IElement e, int index, Point2D pos);
	
	/**
	 * Set bends
	 * @param e
	 * @param bends
	 * @return true if successful 
	 */
	boolean removeBend(IElement e, Bend b);
	
	/**
	 * move position of a bend
	 * @param e
	 * @param b
	 * @param pos position in element coordinate system
	 */
	void moveBend(IElement e, Bend b, Point2D pos);	
	
	/**
	 * Get bends count
	 * @param e bends
	 * @return bends count
	 */
	int getBendsCount(IElement e);
	
	/**
	 * Get Element path
	 * @param e
	 * @return
	 */
	Path2D getPath(IElement e);
	
	/**
	 * Set element path
	 * @param e
	 * @param p
	 */
	void setPath(IElement e, Path2D p);
}
