/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element;


/**
 * An IElementClassProvider provides an abstract way of requesting an
 * ElementClass for a specifiable key. The key is purposefully left abstract.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see ElementClassProviders
 */
public interface IElementClassProvider {

    /**
     * Provides value for a key.
     * 
     * @param key the key
     * @return the value or <code>null</code> if there's no value
     */
    ElementClass get(Object key);

}
