/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.g2d.canvas;

import org.simantics.g2d.chassis.ICanvasChassis;
import org.simantics.g2d.chassis.ITooltipProvider;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.events.IEventHandlerStack;
import org.simantics.scenegraph.g2d.events.IEventQueue;
import org.simantics.utils.datastructures.context.IContext;
import org.simantics.utils.datastructures.disposable.IDisposable;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintStack;
import org.simantics.utils.threads.IThreadWorkQueue;


/**
 * Canvas context.
 *
 * TODO Add Mouse(Id) Discovery and enumeration
 */
public interface ICanvasContext extends
IContext<ICanvasParticipant>,
IDisposable
{

    /**
     * Get content monitor context.
     * @return
     */
    IContentContext getContentContext();
    void setContentContext(IContentContext ctx);

    /**
     * Get Event queue
     * @return event queue
     */
    IEventQueue getEventQueue();


    /**
     * Get event handler stack. Higher priority event handlers get events first.
     *
     * @return the stack
     */
    IEventHandlerStack getEventHandlerStack();

    /**
     * Get the hint stack of this interactor context.
     * Any interactor that adds a layer into the stack should also remove it
     * if the context is changed.
     *
     * @return the hint stack
     */
    IHintStack getHintStack();

    /**
     * Get the hint context of lowest priority in the stack.
     *
     * @return hint context.
     */
    IHintContext getDefaultHintContext();

    /**
     * Get the thread that is used for handling events and painting.
     * External modifications to the three stacks (painter, event handler,
     * and hint stack) and to the participant context must be made
     * in this thread.
     *
     * All participant events / painting is executed from this thread.
     *
     * @return access to thread
     */
    IThreadWorkQueue getThreadAccess();

    /**
     * Set mouse cursor context. Initially there is a default context.
     * @param mctx
     */
    void setMouseCursorContext(IMouseCursorContext mctx);
    IMouseCursorContext getMouseCursorContext();


    /**
     * Set mouse capture context. Initially there is a default context.
     * @param mctx
     */
    void setMouseCaptureContext(IMouseCaptureContext mctx);
    IMouseCaptureContext getMouseCaptureContext();

    /**
     * @return the scene graph root node associated with this canvas context
     */
    G2DSceneGraph getSceneGraph();

    G2DParentNode getCanvasNode();
    void setCanvasNode(G2DParentNode node);

    /**
     * Set the locked state of the canvas context. A locked canvas context may
     * not be rendered. Unlocking a canvas context automatically marks the
     * canvas context dirty. It will be repainted if attached to an
     * {@link ICanvasChassis}. Invocations that don't change locked state do
     * nothing.
     * 
     * @param locked <code>true</code> to lock, <code>false</code> to unlock
     */
    void setLocked(boolean locked);

    /**
     * Tells whether the canvas context is locked. A locked canvas context is
     * not allowed to be rendered by an {@link ICanvasChassis}. This is
     * necessary for performing safe and glitch-free batch initialization on the
     * canvas context.
     * 
     * @return <code>true</code> if locked
     */
    boolean isLocked();
    
    /**
     * Get Tooltip provider
     * @return tooltip provider
     */
    ITooltipProvider getTooltipProvider();
    
    void setTooltipProvider( ITooltipProvider tooltipProvider );

}
