package org.simantics.export.core.intf;

import org.simantics.export.core.error.ExportException;

/**
 * Publisher
 *
 * @author toni.kalajainen@semantum.fi
 */
public interface Publisher {

	/**
	 * Identifier of the publiser extension.
	 * 
	 * @return id
	 */
	String id();
	
	/**
	 * Label of the publisher
	 * @return the label
	 */
	String label();
	
	/**
	 * Create class for publishing data.
	 * 
	 * @return
	 * @throws ExportException
	 */
	PublisherClass publisherClass() throws ExportException;
	
}
