/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.handler;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.TagUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.request.Read;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

class PreferenceHandler
extends AbstractHandler
implements IElementUpdater {
    protected final String virtualGraphId;
    private final String tagURI;
    private final boolean tag;

    public PreferenceHandler() {
        this("preferences", null, false);
    }

    public PreferenceHandler(String tagURI, boolean tag) {
        this("preferences", tagURI, tag);
    }

    public PreferenceHandler(String virtualGraphId) {
        this(virtualGraphId, null, false);
    }

    public PreferenceHandler(String virtualGraphId, String tagURI, boolean tag) {
        this.virtualGraphId = virtualGraphId;
        this.tagURI = tagURI;
        this.tag = tag;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Session session = Simantics.peekSession();
        if (session == null) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        List resources = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        new TagUtil(this.virtualGraphId, this.tagURI, this.tag){

            protected void processSelection(WriteGraph graph, List<Resource> resources) throws DatabaseException {
                if (!PreferenceHandler.this.process(graph)) {
                    return;
                }
                super.processSelection(graph, resources);
            }
        }.execute(session, resources);
        return null;
    }

    protected boolean process(WriteGraph graph) throws DatabaseException {
        return true;
    }

    public void updateElement(UIElement element, Map parameters) {
        Session session = Simantics.peekSession();
        if (session == null) {
            return;
        }
        try {
            boolean checked = (Boolean)session.syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    return PreferenceHandler.this.isChecked(graph);
                }
            });
            element.setChecked(checked);
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    protected boolean isChecked(ReadGraph graph) throws DatabaseException {
        return false;
    }
}

