/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.event.view.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.event.ontology.EventResource;
import org.simantics.layer0.Layer0;

/**
 * Query the all milestones of an event log. 
 * The result is an array if resourcs, ordered by time in ascending order.  
 *  
 * @author toni.kalajainen
 */
public class MilestoneListQuery extends ResourceRead<MilestoneList> {
	
	public MilestoneListQuery(Resource eventlog) {
		super(eventlog);
	}
	
    @Override
    public MilestoneList perform(final ReadGraph graph) throws DatabaseException {
    	MilestoneList result = new MilestoneList();
    	result.milestones = new ArrayList<Resource>();
    	Layer0 L0 = Layer0.getInstance(graph);
        final EventResource EVENT = EventResource.getInstance(graph);

        //System.out.println("listing milestones");
        ArrayList<Resource> list = new ArrayList<Resource>();
        Resource eventLog = resource;
        if (eventLog != null) {
        	result.baseline = graph.getPossibleObject(eventLog, EVENT.EventLog_HasBaselineEvent);
        	for (Resource slice : graph.getObjects(eventLog, L0.ConsistsOf)) {
            	for (Resource event : graph.getObjects(slice, L0.ConsistsOf)) {
            		if (!graph.hasStatement(event, EVENT.Milestone)) continue;
            		list.add(event);
            	}
        	}
        }
        
        Collections.sort(list, new Comparator<Resource>() {
			@Override
			public int compare(Resource o1, Resource o2) {
				try {
	        		Double t1 = graph.getPossibleRelatedValue(o1, EVENT.HasTimestamp);
	        		Double t2 = graph.getPossibleRelatedValue(o2, EVENT.HasTimestamp);
	        		if (t1==null) t1 = 0.0;
	        		if (t2==null) t2 = 0.0;
					return Double.compare(t1, t2);
				} catch (ManyObjectsForFunctionalRelationException e) {
					return 0;
				} catch (ServiceException e) {
					return 0;
				}
			}});
		result.milestones = list;
        return result;
    }

	public Resource getEventLog() {
		return resource;
	}	


}
