package org.simantics.layer0;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class DublinCore {
    
    public final Resource Bar;
    public final Resource Contributor;
    public final Resource Coverage;
    public final Resource Creator;
    public final Resource Date;
    public final Resource Date_Inverse;
    public final Resource Description;
    public final Resource Foo;
    public final Resource Format;
    public final Resource Identifier;
    public final Resource Identifier_Inverse;
    public final Resource Language;
    public final Resource Publisher;
    public final Resource Relation;
    public final Resource Rights;
    public final Resource Source;
    public final Resource Subject;
    public final Resource Title;
    public final Resource Type;
        
    public static class URIs {
        public static final String Bar = "http://www.simantics.org/DublinCore-1.1/Bar";
        public static final String Contributor = "http://www.simantics.org/DublinCore-1.1/Contributor";
        public static final String Coverage = "http://www.simantics.org/DublinCore-1.1/Coverage";
        public static final String Creator = "http://www.simantics.org/DublinCore-1.1/Creator";
        public static final String Date = "http://www.simantics.org/DublinCore-1.1/Date";
        public static final String Date_Inverse = "http://www.simantics.org/DublinCore-1.1/Date/Inverse";
        public static final String Description = "http://www.simantics.org/DublinCore-1.1/Description";
        public static final String Foo = "http://www.simantics.org/DublinCore-1.1/Foo";
        public static final String Format = "http://www.simantics.org/DublinCore-1.1/Format";
        public static final String Identifier = "http://www.simantics.org/DublinCore-1.1/Identifier";
        public static final String Identifier_Inverse = "http://www.simantics.org/DublinCore-1.1/Identifier/Inverse";
        public static final String Language = "http://www.simantics.org/DublinCore-1.1/Language";
        public static final String Publisher = "http://www.simantics.org/DublinCore-1.1/Publisher";
        public static final String Relation = "http://www.simantics.org/DublinCore-1.1/Relation";
        public static final String Rights = "http://www.simantics.org/DublinCore-1.1/Rights";
        public static final String Source = "http://www.simantics.org/DublinCore-1.1/Source";
        public static final String Subject = "http://www.simantics.org/DublinCore-1.1/Subject";
        public static final String Title = "http://www.simantics.org/DublinCore-1.1/Title";
        public static final String Type = "http://www.simantics.org/DublinCore-1.1/Type";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public DublinCore(ReadGraph graph) {
        Bar = getResourceOrNull(graph, URIs.Bar);
        Contributor = getResourceOrNull(graph, URIs.Contributor);
        Coverage = getResourceOrNull(graph, URIs.Coverage);
        Creator = getResourceOrNull(graph, URIs.Creator);
        Date = getResourceOrNull(graph, URIs.Date);
        Date_Inverse = getResourceOrNull(graph, URIs.Date_Inverse);
        Description = getResourceOrNull(graph, URIs.Description);
        Foo = getResourceOrNull(graph, URIs.Foo);
        Format = getResourceOrNull(graph, URIs.Format);
        Identifier = getResourceOrNull(graph, URIs.Identifier);
        Identifier_Inverse = getResourceOrNull(graph, URIs.Identifier_Inverse);
        Language = getResourceOrNull(graph, URIs.Language);
        Publisher = getResourceOrNull(graph, URIs.Publisher);
        Relation = getResourceOrNull(graph, URIs.Relation);
        Rights = getResourceOrNull(graph, URIs.Rights);
        Source = getResourceOrNull(graph, URIs.Source);
        Subject = getResourceOrNull(graph, URIs.Subject);
        Title = getResourceOrNull(graph, URIs.Title);
        Type = getResourceOrNull(graph, URIs.Type);
    }
    
    public static DublinCore getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        DublinCore ret = session.peekService(DublinCore.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new DublinCore(qc.getIndependentGraph(graph));
            session.registerService(DublinCore.class, ret);
        }
        return ret;
    }
    
    public static DublinCore getInstance(RequestProcessor session) throws DatabaseException {
        DublinCore ret = session.peekService(DublinCore.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<DublinCore>() {
                public DublinCore perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new DublinCore(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(DublinCore.class, ret);
        }
        return ret;
    }
    
}

