/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.image2.ontology.ImageResource;

public class DocumentDialect {
    public static final DocumentDialect INSTANCE = new DocumentDialect();
    public static final String SIMANTICS_INTERNAL_URI_PREFIX = "http://simantics-internal/";
    private static final String HTTP = "http://";
    private static final String ROOT = "root:/";
    private static final String IMAGE = "image";
    private static final String MEDIA = "media";
    final Pattern imageOrMediaPattern = Pattern.compile("\\[\\[([Ii]mage|[Mm]edia)(?::([^\\]]+))?\\]\\]");

    private static String digest(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(bytes);
        BigInteger number = new BigInteger(1, md.digest());
        return number.toString(16);
    }

    private static String imageExtension(ReadGraph graph, Resource image) throws DatabaseException {
        ImageResource IMAGE = ImageResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(image, IMAGE.PngImage)) {
            return ".png";
        }
        if (graph.isInstanceOf(image, IMAGE.JpegImage)) {
            return ".jpg";
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String transform(ReadGraph graph, Resource res, String type, String options) {
        try {
            String[] parts = options.split("\\|");
            if (parts.length > 0) {
                String uri = parts[0];
                Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(res));
                if (indexRoot == null) {
                    return null;
                }
                String rootURI = graph.getURI(indexRoot);
                uri = uri.replace(ROOT, rootURI);
                uri = uri.replace(" ", "%20");
                if (IMAGE.equals(type)) {
                    Resource image = graph.getPossibleResource(uri);
                    if (image == null) {
                        return null;
                    }
                    String extension = DocumentDialect.imageExtension(graph, image);
                    if (extension == null) {
                        return null;
                    }
                    byte[] bytes = (byte[])graph.getValue(image, (Binding)Bindings.BYTE_ARRAY);
                    String digest = DocumentDialect.digest(bytes);
                    Path dir = Simantics.getTemporaryDirectory((String)"documentImages").toPath();
                    Files.createDirectories(dir, new FileAttribute[0]);
                    Path f = dir.resolve(digest + extension);
                    if (!Files.exists(f, new LinkOption[0])) {
                        Files.write(f, bytes, new OpenOption[0]);
                    }
                    StringBuilder sb = new StringBuilder(128);
                    sb.append("[[File: ").append(f.toUri());
                    int i = 1;
                    while (i < parts.length) {
                        sb.append("|").append(parts[i]);
                        ++i;
                    }
                    sb.append("]]");
                    return sb.toString();
                }
                if (MEDIA.equals(type)) {
                    Resource image = graph.getPossibleResource(uri);
                    if (image == null) {
                        return null;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("[").append(SIMANTICS_INTERNAL_URI_PREFIX).append(uri);
                    int i = 1;
                    while (i < parts.length) {
                        sb.append(" ").append(parts[i]);
                        ++i;
                    }
                    sb.append("]");
                    return sb.toString();
                }
            }
        }
        catch (DatabaseException databaseException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    public String apply(ReadGraph graph, Resource res, String markup) throws DatabaseException {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = this.imageOrMediaPattern.matcher(markup);
        while (matcher.find()) {
            matcher.appendReplacement(sb, "");
            String type = matcher.group(1);
            String options = matcher.group(2);
            String match = this.transform(graph, res, type.toLowerCase(), options);
            if (match != null) {
                sb.append(match);
                continue;
            }
            sb.append("[[Image:" + options + "]]");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

