package org.simantics.document.swt.core.widget;

import java.util.Arrays;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.server.io.CommandContextImpl;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.base.LeafWidgetManager;
import org.simantics.document.swt.core.bean.StringList;

public class ComboWidget extends LeafWidgetManager<Combo> {
	
	private ModifyListener modifyListener = null;

	private StringList extractAvailable(Object o) {
		if(o instanceof StringList) return (StringList)o;
		if(o instanceof List) return new StringList((List)o);
		if(o instanceof String[]) return new StringList((String[])o);
		throw new IllegalArgumentException("Unaccepted format for available " + o.getClass().getName());
	}
	
	@Override
	protected void doUpdateProperties(SWTDocument document, Combo combo, JSONObject object) {

		if(combo.isDisposed()) return;
		
		if(modifyListener != null)
			combo.removeModifyListener(modifyListener);
		
		StringList availableList = extractAvailable(object.getJSONField("available"));
		String selected = object.getJSONField("selected");

		String[] available = availableList.strings;
		String[] current = combo.getItems();
		
		if(!Arrays.equals(available, current)) {
	        combo.clearSelection();
	        combo.removeAll();
	        for(String key : available) {
	        	combo.add(key);
	        }
		}
		
		int index = 0;
		for(;index<available.length;index++) if(available[index].equals(selected)) break;

		if(index == available.length) {
			combo.clearSelection();
		} else {
			combo.select(index);
		}

		if(modifyListener != null)
			combo.addModifyListener(modifyListener);

	}

	@Override
	protected Combo doCreateControl(final SWTDocument document, Composite parent, JSONObject object) {
		final Combo combo = new Combo(parent, SWT.READ_ONLY);
		final AbstractEventHandler onModify = object.getJSONField("onModify");
		if(onModify != null) {
			modifyListener = new ModifyListener() {
				
				@Override
				public void modifyText(ModifyEvent e) {
					String[] items = combo.getItems();
					int index = combo.getSelectionIndex();
					if(index >=0 && index < items.length) {
		                CommandContextImpl parameters = new CommandContextImpl();
		                parameters.putString("selected", items[index]);
						document.post(onModify, parameters);
					}
					
				}
				
			};
			combo.addModifyListener(modifyListener);
		}
		return combo;
	}
	
}
