/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.swt.core.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.simantics.document.server.IEventCommand;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.bean.Command;
import org.simantics.document.server.client.CommandManager;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandContextImpl;
import org.simantics.document.server.io.CommandContextMutable;
import org.simantics.document.server.io.ICommand;
import org.simantics.document.server.io.JSONObjectUtils;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.SWTViews;
import org.simantics.document.swt.core.base.LeafWidgetManager;
import org.simantics.document.swt.core.base.PostEventCommand;
import org.simantics.document.swt.core.base.WidgetContainer;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.SWTUtils;

public class ButtonWidget extends LeafWidgetManager<Button> {

	@Override
	protected void doUpdateProperties(SWTDocument document, Button control, JSONObject object) {

		if(control.isDisposed()) return;
		
		String text = object.getJSONField("text");
		
		control.setText(text);
		
		document.layout();
		
	}
    
	@Override
	protected Button doCreateControl(final SWTDocument document, Composite parent, final JSONObject object) {

		final Button label = new Button(parent, SWT.NONE);
		
//		final EventHandler onPress = object.getJSONField("onPress");
//		label.addSelectionListener(new );

		return label;
	}
	
    public static class ButtonCommandManager implements CommandManager<SWTDocument, WidgetContainer<Button>> {

        @Override
        public Collection<Object> updateCommandListeners(final SWTDocument document, final JSONObject object,
                WidgetContainer<Button> container) {
            
            WidgetData wd = document.getWidget(JSONObjectUtils.getId(object));
            List<ICommand> commands = object.getJSONField("commands");
            HashSet<Object> listeners = new HashSet<Object>();
            List<Pair<WidgetData, ICommand>> data = new ArrayList<>();
            data.addAll(SWTViews.getTriggeredCommands(document, commands, "click"));
            data.addAll(SWTViews.getTriggeredCommands(document, commands, "eventOut"));
            data.add(new Pair<WidgetData, ICommand>(wd, new Command("onPress")));
            SelectionListener listener = new ButtonSelectionListener(wd, data);
            Button button = container.getControl();
            if(!button.isDisposed()) {
            	button.addSelectionListener(listener);
                listeners.add(listener);
            }
            
            return listeners;
            
        }

        @Override
        public void removeListener(WidgetContainer<Button> container, Object listener) {
        	if(container.getControl().isDisposed()) return;
            if(listener instanceof SelectionListener)
                container.getControl().removeSelectionListener((SelectionListener) listener);
        }

    }

    @Override
    public IEventCommand eventCommand(SWTDocument document, JSONObject object, WidgetContainer widget, ICommand command, CommandContext p) {
        if("onPress".equals(command.getCommand())) {
            CommandContextMutable context = new CommandContextImpl().merge(p);
            AbstractEventHandler onPress = object.getJSONField("onPress");
            if(onPress == null) return null;
            return new PostEventCommand(document, onPress, context);
        }
        return null;
    }	
	
}
