/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.swt.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.client.CommandMapping;
import org.simantics.document.server.client.CommandMappingImpl;
import org.simantics.document.server.client.Document;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.server.client.WidgetMapping;
import org.simantics.document.server.client.WidgetMappingImpl;
import org.simantics.document.server.io.ICommand;
import org.simantics.document.swt.core.base.ScrolledCompositeContent;
import org.simantics.document.swt.core.widget.BrowserWidget;
import org.simantics.document.swt.core.widget.ButtonWidget;
import org.simantics.document.swt.core.widget.ComboWidget;
import org.simantics.document.swt.core.widget.CommandEventWidget;
import org.simantics.document.swt.core.widget.Explorer;
import org.simantics.document.swt.core.widget.FillComposite;
import org.simantics.document.swt.core.widget.GridCell;
import org.simantics.document.swt.core.widget.GridComposite;
import org.simantics.document.swt.core.widget.LabelWidget;
import org.simantics.document.swt.core.widget.SCLTextEditor;
import org.simantics.document.swt.core.widget.ScrolledCompositeWidget;
import org.simantics.document.swt.core.widget.TrackedTextWidget;
import org.simantics.utils.datastructures.Pair;

public class SWTViews {

	private static WidgetMappingImpl mapping = null;

	public static WidgetMapping getMapping() {

		if(mapping == null) {
			mapping = new WidgetMappingImpl();
			mapping.register("Root", new FillComposite());
			mapping.register("GridComposite", new GridComposite());
			mapping.register("ScrolledComposite", new ScrolledCompositeWidget());
			mapping.register("GridCell", new GridCell());
			mapping.register("Label", new LabelWidget());
			mapping.register("Button", new ButtonWidget());
			mapping.register("TrackedText", new TrackedTextWidget());
			mapping.register("Combo", new ComboWidget());
			mapping.register("Explorer", new Explorer());
			mapping.register("CommandEvent", new CommandEventWidget());
			mapping.register("Browser", new BrowserWidget());
			mapping.register("SCLTextEditor", new SCLTextEditor());
		}

		return mapping;

	}

	private static CommandMappingImpl commandMapping = null;

	public static CommandMapping getCommandMapping() {

		if(commandMapping == null) {
			commandMapping = new CommandMappingImpl();
			commandMapping.register("Button", new ButtonWidget.ButtonCommandManager());
			commandMapping.register("Explorer", new Explorer.ExplorerCommandManager());
		}

		return commandMapping;

	}

	public static List<Pair<WidgetData, ICommand>> getTriggeredCommands(Document document, Collection<ICommand> commands, String trigger) {
		// Nulls should not get this far
		assert(commands != null);
		List<Pair<WidgetData, ICommand>> data = new ArrayList<>();
		for(ICommand c : commands) {
			if(c.getCommand() == null || c.getTargetId() == null || c.getTrigger() == null)
				continue;
			if(trigger.equals(c.getTrigger())) {
				WidgetData wd = document.getWidgetData().get(c.getTargetId());
				if(wd != null)
					data.add(new Pair<WidgetData, ICommand>(wd, c));
			}
		}
		return data;
	}

	public static void notifyScrolledComposite(Control c) {
		if(c instanceof ScrolledCompositeContent) {
			ScrolledCompositeContent content = (ScrolledCompositeContent)c;
			content.refreshSize();
			return;
		}
		Composite parent = c.getParent();
		if(parent == null) return;
		notifyScrolledComposite(parent);
	}

	public static Map<String, Object> encoded = new HashMap<String, Object>();

	public static String encode(JSONObject object, String property, Object data) {
	    String key = object.getId() + "#" + property;
	    encoded.put(key, data);
	    return key;
	}

	public static Object decode(String key) {
	    return encoded.get(key);
	}

}
