package org.simantics.document.server.handler;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandResult;
import org.simantics.document.server.serverResponse.Error;
import org.simantics.document.server.serverResponse.IDelayedResponse;
import org.simantics.document.server.serverResponse.ServerResponse;

public abstract class EventHandler extends AbstractEventHandler {
	
    protected abstract ServerResponse handle(ReadGraph graph, CommandContext parameters) throws DatabaseException;

    public CommandResult handle(final CommandContext parameters) {
        try {
            ServerResponse response = Simantics.getSession().syncRequest(new Read<ServerResponse>() {
                @Override
                public ServerResponse perform(ReadGraph graph) throws DatabaseException {
                    return handle(graph, parameters);
                }
            });

            if(response instanceof IDelayedResponse && !(((IDelayedResponse)response).hasRun())) {
                try {
                    synchronized(response) {
                        response.wait(20000);
                    }
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            
            return response;
        } catch (DatabaseException e) {
            e.printStackTrace();
            return new Error(e.getMessage()); // Return some error
        }
    }

}
