package org.simantics.document.server.handler;

import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandResult;
import org.simantics.scl.runtime.function.Function1;

public abstract class AbstractResponseHandler extends AbstractEventHandler {

	protected Function1<CommandContext, CommandResult> fn;
	
	public AbstractResponseHandler(Function1<CommandContext, CommandResult> fn) {
		this.fn = fn;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((fn == null) ? 0 : fn.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AbstractResponseHandler other = (AbstractResponseHandler) obj;
		if (fn == null) {
			if (other.fn != null)
				return false;
		} else if (!fn.equals(other.fn))
			return false;
		return true;
	}
	
}