package org.simantics.document.server;

import java.util.List;
import java.util.Map;

import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.service.CollectionSupport;
import org.simantics.structural2.scl.StructuralComponent;

public class VariableStructuralContext extends StructuralComponent<Variable> {

	final private Variable selfVariable;
	final private Variable variable;
	
	public VariableStructuralContext(ReadGraph graph, Variable selfVariable) throws DatabaseException {
		this.selfVariable = selfVariable;
		this.variable = selfVariable.getParent(graph).getParent(graph);
	}
	
	@Override
	public Resource getType(ReadGraph g) throws DatabaseException {
		throw new UnsupportedOperationException();
	}
	
	static class MapRequest extends VariableRead<Map<Resource,Variable>> {

		public MapRequest(Variable component) {
			super(component);
		}

		@Override
		public Map<Resource, Variable> perform(ReadGraph graph) throws DatabaseException {
			
			CollectionSupport cs = graph.getService(CollectionSupport.class);
			Map<Resource, Variable> result = cs.createMap(Variable.class);
			for(Variable property : variable.getProperties(graph)) {
				Resource predicate = property.getPossiblePredicateResource(graph);
				if(predicate != null)
					result.put(predicate, property);
			}
			return result;
			
		}
		
	}

	@Override
	public Object getValue(ReadGraph g, Resource attribute, Binding binding) throws DatabaseException, AdaptException {
		
		Map<Resource,Variable> map = g.syncRequest(new MapRequest(variable));
		Variable p = map.get(attribute);
		if(p != null) {
			if(binding != null)
				return p.getValue(g, binding);
			else
				return p.getValue(g);
		}
		
		return null;
		
	}

	@Override
	public boolean isParametrized(ReadGraph g) throws DatabaseException {
		throw new UnsupportedOperationException();
	}

	@Override
	public Variable getConnection(ReadGraph g, Resource connectionPoint) throws DatabaseException {
		throw new UnsupportedOperationException();
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	public List getConnections(ReadGraph g, Resource connectionPoint) throws DatabaseException {
		throw new UnsupportedOperationException();
	}

	@Override
	public Resource getResource() {
		throw new UnsupportedOperationException();
	}

    @Override
    public StructuralComponent<Variable> getContext() {
        return null;
    }

}
