/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.evaluator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.Activator;
import org.simantics.document.linking.report.DocumentLine;
import org.simantics.document.linking.report.evaluator.EvaluatorItem;
import org.simantics.document.linking.report.evaluator.EvaluatorNode;
import org.simantics.document.linking.report.evaluator.StringEditableNode;
import org.simantics.objmap.graph.annotations.OrderedSetType;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;

@OrderedSetType(value="http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/And")
public class And
extends EvaluatorNode
implements StringEditableNode {
    String separator;

    public And() {
        this.separator = " ";
    }

    public And(String separator) {
        this.separator = separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getSeparator() {
        return this.separator;
    }

    @Override
    public String getValue(ReadGraph graph, Variable variable, Map<Object, Object> context) throws DatabaseException {
        Object s = "";
        int i = 0;
        while (i < this.children.size()) {
            String s2 = ((EvaluatorItem)this.children.get(i)).getValue(graph, variable, context);
            if (s2 != null) {
                s = (String)s + s2;
                if (i < this.children.size() - 1) {
                    s = (String)s + this.separator;
                }
            }
            ++i;
        }
        if (((String)s).length() == 0) {
            return null;
        }
        return s;
    }

    @Override
    public List<DocumentLine> getLines(ReadGraph graph, Variable variable, Map<Object, Object> context) throws DatabaseException {
        ArrayList<DocumentLine> result = new ArrayList<DocumentLine>();
        int i = 0;
        while (i < this.children.size()) {
            List<DocumentLine> list = ((EvaluatorItem)this.children.get(i)).getLines(graph, variable, context);
            int j = 0;
            while (j < list.size()) {
                DocumentLine line = list.get(j);
                if (j <= result.size()) {
                    result.add(line);
                } else {
                    DocumentLine extLine = (DocumentLine)result.get(j);
                    String combined = extLine.getLine() + this.separator + line.getLine();
                    HashMap<Object, Object> combinedSet = new HashMap<Object, Object>();
                    combinedSet.putAll(extLine.getHints());
                    combinedSet.putAll(line.getHints());
                    result.set(j, new DocumentLine(combined, combinedSet));
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        return "and (" + this.separator + ")";
    }

    @Override
    @RelatedGetValue(value="http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/HasValue")
    public String getValue() {
        return this.separator;
    }

    @Override
    public String setValue(String value) {
        this.separator = value;
        return null;
    }

    @RelatedSetValue(value="http://www.simantics.org/DocumentLink-1.0/EvaluatorTree/HasValue")
    public void _setValue(String value) {
        this.separator = value;
    }

    @Override
    public EvaluatorItem copy() {
        And a = new And(this.separator);
        this.copyChildren(a);
        return a;
    }

    @Override
    public ImageDescriptor getImage() {
        return Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/text_columns.png");
    }
}

