/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Consumer;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.simantics.utils.ui.ErrorLogger;

public class JColorChooserDialog {
    private JColorChooser colorChooser;
    private OkListener okListener;
    private Color color;

    private JColorChooserDialog(String title, Color initialColor) {
        this.colorChooser = new JColorChooser(initialColor);
        this.okListener = new OkListener();
        JDialog dialog = JColorChooser.createDialog(null, title, true, this.colorChooser, this.okListener, null);
        dialog.setVisible(true);
    }

    public static void show(final String title, final Color initialColor, final Consumer<Color> listener) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    ErrorLogger.defaultLogError((Throwable)e);
                }
                JColorChooserDialog dialog = new JColorChooserDialog(title, initialColor);
                if (listener != null) {
                    listener.accept(dialog.color);
                }
            }
        });
    }

    private class OkListener
    implements ActionListener {
        private OkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JColorChooserDialog.this.color = JColorChooserDialog.this.colorChooser.getColor();
        }
    }
}

