/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.handler.DeleteRouteLine;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.elementclass.RouteGraphConnectionClass;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.ui.selection.WorkbenchSelectionUtils;

public class DeleteAllRouteLines
extends AbstractHandler {
    private List<Resource> getConnections(ISelection s) throws DatabaseException {
        List els = WorkbenchSelectionUtils.getWorkbenchSelectionElements((ISelection)s);
        if (els.isEmpty()) {
            return Collections.emptyList();
        }
        return (List)Simantics.getSession().syncRequest(graph -> {
            ArrayList<Resource> rs = new ArrayList<Resource>();
            for (WorkbenchSelectionElement wse : els) {
                Resource r = WorkbenchSelectionUtils.getPossibleResource((RequestProcessor)graph, (Object)wse);
                if (r == null) continue;
                rs.add(r);
            }
            return rs;
        });
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        try {
            List<Resource> rs = this.getConnections(sel);
            if (!rs.isEmpty()) {
                ICanvasContext ctx = DeleteRouteLine.getCanvasContext(event);
                IDiagram diagram = DeleteRouteLine.getDiagram(ctx);
                DataElementMap dem = DeleteRouteLine.getDataMap(diagram);
                Simantics.getSession().markUndoPoint();
                List nodes = rs.stream().map(r -> {
                    IElement e = dem.getElement(diagram, r);
                    Node node = e != null ? (Node)e.getHint(RouteGraphConnectionClass.KEY_RG_NODE) : null;
                    return node instanceof RouteGraphNode ? (RouteGraphNode)node : null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                for (RouteGraphNode node : nodes) {
                    node.removeAllPersistentLines();
                }
            }
            return null;
        }
        catch (DatabaseException e) {
            throw new ExecutionException("Failed to all delete route lines from selected connections", (Throwable)e);
        }
    }
}

