/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.function;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.simantics.Simantics;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.request.PossibleConfiguration;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.ValueAccessorWithBinding;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.diagram.content.ElementContext;
import org.simantics.diagram.flag.FlagLabelModifier;
import org.simantics.diagram.function.PredefinedVariables;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.ui.JColorChooserDialog;
import org.simantics.issues.common.IssueUtils;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.scenegraph.loader.SceneGraphContext;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.ui.fonts.Fonts;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;

public class All {
    @SCLValue(type="ValueAccessor")
    public static ValueAccessor colorDisplayValueAccessor = new ValueAccessor(){

        public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
            return Datatypes.STRING;
        }

        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            return this.getValue(graph, context, (Binding)Bindings.STRING);
        }

        public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
            Variable colorVar = context.getParent(graph);
            Variable parent = context.getParent(graph).getParent(graph);
            float[] rgb = (float[])parent.getPossiblePropertyValue(graph, colorVar.getName(graph), (Binding)Bindings.FLOAT_ARRAY);
            Color color = new Color(Math.round(rgb[0] * 255.0f), Math.round(rgb[1] * 255.0f), Math.round(rgb[2] * 255.0f), Math.round(rgb[3] * 255.0f));
            return All.convertColorToHexadecimal(color);
        }

        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            this.setValue(graph, context, value, (Binding)Bindings.STRING);
        }

        public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
            Variable property = context.getParent((ReadGraph)graph);
            Color col = All.convertHexadecimalToColor((String)value);
            float[] color = new float[]{(float)col.getRed() / 255.0f, (float)col.getGreen() / 255.0f, (float)col.getBlue() / 255.0f, (float)col.getAlpha() / 255.0f};
            property.setValue(graph, (Object)color, (Binding)Bindings.FLOAT_ARRAY);
        }
    };
    @SCLValue(type="ValueAccessor")
    public static final ValueAccessor flagLabelValueAccessor = new FlagLabelValueAccessor();

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable defaultRuntimeVariable(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        SceneGraphContext vc = ScenegraphLoaderUtils.getContext((ReadGraph)graph, (Variable)context);
        if (vc == null) {
            return null;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        String uri = (String)graph.getRelatedValue(vc.getRuntime(), DIA.RuntimeDiagram_HasVariable, (Binding)Bindings.STRING);
        return Variables.getVariable((ReadGraph)graph, (String)uri);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String referenceText(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        String path = (String)context.getParent(graph).getPropertyValue(graph, "reference", (Binding)Bindings.STRING);
        try {
            Variable selection = ScenegraphLoaderUtils.getPossibleVariableSelection((ReadGraph)graph, (Variable)context);
            PredefinedVariables vars = PredefinedVariables.getInstance();
            Variable property = vars.getVariable(graph, path, converter, selection);
            if (property != null) {
                return property.getValue(graph).toString();
            }
        }
        catch (MissingVariableException missingVariableException) {
            return "Invalid path.";
        }
        return null;
    }

    @SCLValue(type="ReadGraph -> Resource -> ElementContext -> a")
    public static Object modelledTransform(ReadGraph graph, Resource converter, ElementContext context) throws DatabaseException {
        return graph.getRelatedValue(context.element, G2DResource.getInstance((ReadGraph)graph).HasTransform, (Binding)Bindings.DOUBLE_ARRAY);
    }

    @SCLValue(type="ReadGraph -> Resource -> ElementContext -> a")
    public static Object flagTransform(ReadGraph graph, Resource converter, ElementContext context) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
        Resource flag = context.element;
        Resource runtimeDiagram = context.runtime;
        if (runtimeDiagram == null) {
            return All.flagTransformImpl(graph, converter, context);
        }
        Resource diagram = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
        if (diagram == null) {
            return All.flagTransformImpl(graph, converter, context);
        }
        Resource template = All.getTemplateFromDiagram(graph, diagram);
        if (template == null) {
            return All.flagTransformImpl(graph, converter, context);
        }
        double gridSize = DiagramGraphUtil.getGridSize(graph, diagram, 0.0);
        String tableName = (String)graph.getPossibleRelatedValue(flag, DIA.Flag_HasIOTableBinding, (Binding)Bindings.STRING);
        Integer rowIndex = (Integer)graph.getPossibleRelatedValue(flag, DIA.Flag_HasIOTableRowIndex, (Binding)Bindings.INTEGER);
        Collection slotTables = graph.getObjects(template, L0.ConsistsOf);
        for (Resource slotTable : slotTables) {
            String name;
            if (!graph.isInstanceOf(slotTable, TEMPLATE2D.FlagTable) || !(name = (String)graph.getPossibleRelatedValue(slotTable, L0.HasName, (Binding)Bindings.STRING)).equals(tableName)) continue;
            double[] transform = (double[])graph.getPossibleRelatedValue2(slotTable, DIA.Scenegraph_Composite_transform, Bindings.getBindingUnchecked(double[].class));
            Resource align = graph.getPossibleObject(slotTable, TEMPLATE2D.FlagTable_HasAlignment);
            boolean isRightAlignment = false;
            if (align.equals(TEMPLATE2D.FlagTable_Alignment_Right)) {
                isRightAlignment = true;
            }
            Float width = (Float)graph.getPossibleRelatedValue(slotTable, TEMPLATE2D.FlagTable_HasWidth, (Binding)Bindings.FLOAT);
            Float rowHeight = (Float)graph.getPossibleRelatedValue(slotTable, TEMPLATE2D.FlagTable_HasRowHeigth, (Binding)Bindings.FLOAT);
            double[] flagTransform = (double[])graph.getRelatedValue(flag, DIA.HasTransform, (Binding)Bindings.DOUBLE_ARRAY);
            return All.calcTransform(transform, flagTransform, rowHeight, width, isRightAlignment, rowIndex, gridSize);
        }
        return All.flagTransformImpl(graph, converter, context);
    }

    private static Object flagTransformImpl(ReadGraph graph, Resource converter, ElementContext context) throws DatabaseException {
        double[] mat = (double[])graph.getRelatedValue(context.element, G2DResource.getInstance((ReadGraph)graph).HasTransform, (Binding)Bindings.DOUBLE_ARRAY);
        return mat;
    }

    private static double[] calcTransform(double[] tableTransform, double[] flagTransform, Float rowHeight, Float tableWidth, boolean isRightAlignment, Integer flagRowIndex, double gridSize) {
        double scale = tableTransform[3];
        double scaledRowHeigth = scale * (double)rowHeight.floatValue();
        double rowMiddleY = tableTransform[5] + (double)((float)flagRowIndex.intValue() + 0.5f) * scaledRowHeigth;
        if (gridSize != 0.0) {
            double diff;
            double modulo = rowMiddleY % gridSize;
            int count = (int)(rowMiddleY / gridSize);
            double gridOnRow = modulo > gridSize / 2.0 ? gridSize * (double)(1 + count) : gridSize * (double)count;
            double d = diff = gridOnRow > rowMiddleY ? gridOnRow - rowMiddleY : rowMiddleY - gridOnRow;
            if (diff < scaledRowHeigth / 2.0) {
                rowMiddleY = gridOnRow;
            }
        }
        rowMiddleY = (rowMiddleY - tableTransform[5]) / scale;
        double xx = isRightAlignment ? (double)tableWidth.floatValue() : 0.0;
        AffineTransform trans = new AffineTransform(new double[]{tableTransform[0], tableTransform[1], tableTransform[2], tableTransform[3], 0.0, 0.0});
        Point2D.Double point = new Point2D.Double(xx, rowMiddleY);
        trans.transform(point, point);
        double[] copy = Arrays.copyOf(flagTransform, flagTransform.length);
        copy[4] = tableTransform[4] + ((Point2D)point).getX();
        copy[5] = tableTransform[5] + ((Point2D)point).getY();
        return copy;
    }

    public static Resource getTemplate(ReadGraph graph, Resource runtimeDiagram) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource diagram = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
        if (diagram == null) {
            return null;
        }
        return All.getTemplateFromDiagram(graph, diagram);
    }

    public static Resource getTemplateFromDiagram(ReadGraph graph, Resource diagram) throws DatabaseException {
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
        Resource template = graph.getPossibleObject(diagram, TEMPLATE2D.HasDrawingTemplate);
        return template;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String diagramElementIssuePath(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        List contexts = IssueUtils.getContextsForProperty((ReadGraph)graph, (Variable)property);
        if (contexts.isEmpty()) {
            return "";
        }
        Resource context = (Resource)contexts.get(0);
        Resource mapped = graph.getPossibleObject(context, MOD.ComponentToElement);
        if (mapped != null) {
            context = mapped;
        }
        if ((mapped = graph.getPossibleObject(context, MOD.ConnectionToDiagramConnection)) != null) {
            context = mapped;
        }
        if (!graph.isInstanceOf(context, DIA.Element)) {
            return "";
        }
        Resource configuration = (Resource)graph.sync((ReadInterface)new PossibleConfiguration(context));
        if (configuration == null) {
            return "";
        }
        Resource diagram = graph.getPossibleObject(context, L0.PartOf);
        if (diagram == null) {
            return "";
        }
        Resource composite = graph.getPossibleObject(diagram, MOD.DiagramToComposite);
        if (composite == null) {
            return "";
        }
        Resource issueRoot = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)property);
        if (issueRoot == null) {
            return "";
        }
        Resource contextRoot = (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(composite));
        if (contextRoot == null) {
            return "";
        }
        if (issueRoot.equals(contextRoot)) {
            String uri = graph.getURI(composite);
            String modelURI = graph.getURI(contextRoot);
            return IssueUtils.pathString((String)uri, (int)(modelURI.length() + 1));
        }
        String uri = graph.getURI(composite);
        String modelURI = graph.getURI(graph.getRootLibrary());
        return IssueUtils.pathString((String)uri, (int)(modelURI.length() + 1));
    }

    private static String convertColorToHexadecimal(Color color) {
        return String.format("#%02x%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private static Color convertHexadecimalToColor(String hexadecimal) throws NumberFormatException {
        if (hexadecimal.matches("#[0-9a-fA-F]{8}")) {
            int red = Integer.valueOf(hexadecimal.substring(1, 3), 16);
            int green = Integer.valueOf(hexadecimal.substring(3, 5), 16);
            int blue = Integer.valueOf(hexadecimal.substring(5, 7), 16);
            int alpha = Integer.valueOf(hexadecimal.substring(7, 9), 16);
            return new Color(red, green, blue, alpha);
        }
        return Color.BLACK;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object colorModifier(ReadGraph graph, Resource r, final Variable variable) throws DatabaseException {
        return new Labeler.DialogModifier(){

            public String getValue() {
                return null;
            }

            public String isValid(String label) {
                return null;
            }

            public void modify(final String label) {
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Variable displayValue = variable.getParent((ReadGraph)graph);
                        Variable property = displayValue.getParent((ReadGraph)graph);
                        Color col = All.convertHexadecimalToColor(label);
                        float[] color = new float[]{(float)col.getRed() / 255.0f, (float)col.getGreen() / 255.0f, (float)col.getBlue() / 255.0f, (float)col.getAlpha() / 255.0f};
                        property.setValue(graph, (Object)color, (Binding)Bindings.FLOAT_ARRAY);
                    }
                });
            }

            public String query(Object parentControl, Object controlItem, int columnIndex, NodeContext context, Consumer<String> applyCallback) {
                Color initialColor = null;
                final Variable v = (Variable)AdaptionUtils.adaptToSingle((Object)context, Variable.class);
                if (v != null) {
                    try {
                        initialColor = (Color)Simantics.getSession().syncRequest((Read)new UniqueRead<Color>(){

                            public Color perform(ReadGraph graph) throws DatabaseException {
                                float[] color = (float[])v.getPossibleValue(graph, (Binding)Bindings.FLOAT_ARRAY);
                                if (color != null) {
                                    return new Color(color[0], color[1], color[2], color[3]);
                                }
                                return Color.BLACK;
                            }
                        });
                    }
                    catch (DatabaseException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                }
                JColorChooserDialog.show("Select Color", initialColor, new Consumer<Color>(){

                    @Override
                    public void accept(Color color) {
                        if (color != null) {
                            this.modify(All.convertColorToHexadecimal(color));
                        }
                    }
                });
                return null;
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object fontModifier(ReadGraph graph, Resource r, final Variable variable) throws DatabaseException {
        return new Labeler.DialogModifier(){

            public String getValue() {
                return null;
            }

            public String isValid(String label) {
                return null;
            }

            public void modify(final String label) {
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Variable displayValue = variable.getParent((ReadGraph)graph);
                        displayValue.setValue(graph, (Object)label, (Binding)Bindings.STRING);
                    }
                });
            }

            public String query(Object parentControl, Object controlItem, int columnIndex, final NodeContext context, Consumer<String> applyCallback) {
                FontData font;
                FontData[] initialValue;
                Control ctrl;
                block8: {
                    ctrl = (Control)parentControl;
                    initialValue = null;
                    try {
                        String[] fields;
                        String font2 = (String)Simantics.getSession().syncRequest((Read)new UniqueRead<String>(){

                            public String perform(ReadGraph graph) throws DatabaseException {
                                Variable v = (Variable)AdaptionUtils.adaptToSingle((Object)context, Variable.class);
                                if (v == null) {
                                    return null;
                                }
                                String displayValue = (String)v.getPossiblePropertyValue(graph, "HasDisplayValue", (Binding)Bindings.STRING);
                                return displayValue;
                            }
                        });
                        if (font2 == null || (fields = font2.split(",")).length != 3) break block8;
                        int size = 14;
                        try {
                            size = Integer.parseInt(fields[1]);
                        }
                        catch (NumberFormatException e) {
                            ErrorLogger.defaultLogError((Throwable)e);
                        }
                        int style = 0;
                        try {
                            style = Fonts.swtStyle((String)fields[2]);
                        }
                        catch (RuntimeException e) {
                            ErrorLogger.defaultLogError((Throwable)e);
                        }
                        initialValue = new FontData[]{new FontData(fields[0], size, style)};
                    }
                    catch (DatabaseException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                }
                FontDialog dialog = new FontDialog(ctrl.getShell());
                if (initialValue != null) {
                    dialog.setFontList(initialValue);
                }
                if ((font = dialog.open()) != null) {
                    applyCallback.accept(font.getName() + "," + font.getHeight() + "," + Fonts.fromSwtStyle((int)font.getStyle()));
                }
                return null;
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Function1<String, String> flagLabelValidator(ReadGraph graph, Resource r, Variable context) throws DatabaseException {
        Variable hasLabel = context.getParent(graph).getParent(graph);
        Resource value = hasLabel.getRepresents(graph);
        Resource flag = hasLabel.getParent(graph).getRepresents(graph);
        FlagLabelModifier flm = new FlagLabelModifier(graph, flag, Layer0.getInstance((ReadGraph)graph).HasLabel, value);
        return s -> flm.isValid((String)s);
    }

    static class FlagLabelValueAccessor
    extends ValueAccessorWithBinding {
        FlagLabelValueAccessor() {
        }

        public Binding getBinding() {
            return Bindings.STRING;
        }

        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            return context.getParent(graph).getValue(graph, (Binding)Bindings.STRING);
        }

        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            Variable hasLabel = context.getParent((ReadGraph)graph);
            Resource flag = hasLabel.getParent((ReadGraph)graph).getRepresents((ReadGraph)graph);
            FlagLabelModifier.modify(graph, flag, Layer0.getInstance((ReadGraph)graph).HasLabel, (String)value);
        }
    }
}

