/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.copypaste;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.handler.CopyPasteHandler;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.page.DiagramDesc;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.scenegraph.ICanvasSceneGraphProvider;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.triggers.IActivation;
import org.simantics.layer0.utils.triggers.IActivationManager;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.snap.GridSnapAdvisor;
import org.simantics.structural2.StructuralVariables;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.threads.WorkerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementCopyPaster {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementCopyPaster.class);
    private final WorkerThread thread = new WorkerThread("Copy Paster Diagram Thread");
    private final CanvasContext ctx = new CanvasContext((IThreadWorkQueue)this.thread);
    private IActivation activation;
    private Resource diagram;
    private ICanvasSceneGraphProvider provider;
    private static ElementCopyPaster source;

    public ElementCopyPaster(final Resource diagram) throws Exception {
        this.diagram = diagram;
        this.thread.start();
        final ISessionContext sessionContext = Simantics.getSessionContext();
        DiagramDesc diagramDesc = (DiagramDesc)sessionContext.getSession().syncRequest(DiagramRequests.getDiagramDesc(diagram));
        if (diagramDesc != null) {
            IHintContext h = this.ctx.getDefaultHintContext();
            h.setHint(DiagramHints.SNAP_ADVISOR, (Object)new GridSnapAdvisor(diagramDesc.getGridSize()));
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Pair modelAndRVI = (Pair)sessionContext.getSession().syncRequest((Read)new UniqueRead<Pair<Resource, String>>(){

                        public Pair<Resource, String> perform(ReadGraph graph) throws DatabaseException {
                            Resource model = ElementCopyPaster.resolveModel(graph, diagram);
                            return new Pair((Object)model, (Object)ElementCopyPaster.resolveRVI(graph, model, diagram));
                        }
                    });
                    ElementCopyPaster.this.provider = DiagramNodeUtil.loadSceneGraphProviderForDiagram((ICanvasContext)ElementCopyPaster.this.ctx, (Resource)modelAndRVI.first, diagram, (String)modelAndRVI.second);
                    IActivationManager activationManager = (IActivationManager)sessionContext.getSession().peekService(IActivationManager.class);
                    if (activationManager != null) {
                        ElementCopyPaster.this.activation = activationManager.activate(diagram);
                    }
                }
                catch (InterruptedException | DatabaseException e) {
                    LOGGER.error("Failed to load diagram.", e);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
        t.join();
    }

    private void copyOrCutElementsInternal(final List<Resource> elements, final boolean cut) {
        ThreadUtils.asyncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

            @Override
            public void run() {
                CopyPasteHandler cph = (CopyPasteHandler)((Object)ElementCopyPaster.this.ctx.getAtMostOneItemOfClass(CopyPasteHandler.class));
                try {
                    Collection ielements = (Collection)Simantics.sync((ReadInterface)new UniqueRead<Collection<IElement>>(){

                        public Collection<IElement> perform(ReadGraph graph) throws DatabaseException {
                            ArrayList<IElement> result = new ArrayList<IElement>();
                            for (Resource er : elements) {
                                IElement e = DiagramNodeUtil.findElement((ICanvasContext)(this).ElementCopyPaster.this.ctx, er);
                                result.add(e);
                            }
                            return result;
                        }
                    });
                    Selection selection = (Selection)ElementCopyPaster.this.ctx.getAtMostOneItemOfClass(Selection.class);
                    selection.setSelection(0, ielements);
                    cph.initiateCopy(cut);
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to copy/cut elements.", (Throwable)e);
                }
            }
        });
    }

    private void pasteElementsInternal(final double x, final double y, final Command command) {
        ThreadUtils.syncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

            @Override
            public void run() {
                CopyPasteHandler cph = (CopyPasteHandler)((Object)ElementCopyPaster.this.ctx.getAtMostOneItemOfClass(CopyPasteHandler.class));
                MouseUtil mouseUtil = (MouseUtil)ElementCopyPaster.this.ctx.getSingleItem(MouseUtil.class);
                mouseUtil.handleMouseEvent((MouseEvent)new MouseEvent.MouseMovedEvent(null, 0L, 0, 0, 0, (Point2D)new Point2D.Double(x, y), null));
                cph.initiatePaste(command);
            }
        });
    }

    private static Resource resolveModel(ReadGraph graph, Resource diagram) throws DatabaseException {
        ModelingResources mod = ModelingResources.getInstance((ReadGraph)graph);
        Resource composite = graph.getSingleObject(diagram, mod.DiagramToComposite);
        Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(composite));
        if (model == null) {
            throw new ValidationException("no model found for composite " + NameUtils.getSafeName((ReadGraph)graph, (Resource)composite));
        }
        return model;
    }

    private static String resolveRVI(ReadGraph graph, Resource model, Resource diagram) throws DatabaseException {
        ModelingResources mod = ModelingResources.getInstance((ReadGraph)graph);
        Resource composite = graph.getSingleObject(diagram, mod.DiagramToComposite);
        ResourceArray compositePath = StructuralVariables.getCompositeArray((ReadGraph)graph, (Resource)composite);
        ResourceArray variablePath = compositePath.removeFromBeginning(1);
        return StructuralVariables.getRVI((ReadGraph)graph, (ResourceArray)variablePath);
    }

    public Resource getDiagram() {
        return this.diagram;
    }

    private void dispose() {
        if (this.activation != null) {
            this.activation.deactivate();
        }
        if (this.provider != null) {
            this.provider.dispose();
        }
        if (this.thread != null) {
            this.thread.stopDispatchingEvents(true);
        }
        if (this.ctx != null) {
            this.ctx.dispose();
        }
    }

    public static synchronized void copyElements(List<Resource> elements) throws Exception {
        ElementCopyPaster.copyOrCutElements(elements, false);
    }

    public static synchronized void cutElements(List<Resource> elements) throws Exception {
        ElementCopyPaster.copyOrCutElements(elements, true);
    }

    private static void copyOrCutElements(List<Resource> elements, boolean cut) throws Exception {
        if (elements.isEmpty()) {
            if (source != null) {
                source.dispose();
                source = null;
            }
        } else {
            final Resource first = elements.get(0);
            Resource diagram = (Resource)Simantics.sync((ReadInterface)new ResourceRead<Resource>(first){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    return graph.getSingleObject(first, L0.PartOf);
                }
            });
            if (source == null || source.getDiagram() != diagram) {
                if (source != null) {
                    source.dispose();
                }
                source = new ElementCopyPaster(diagram);
            }
            source.copyOrCutElementsInternal(elements, cut);
        }
    }

    public static synchronized void pasteElements(Resource targetDiagram, double x, double y) throws Exception {
        ElementCopyPaster.pasteElementsWithCommand(targetDiagram, x, y, Commands.PASTE);
    }

    public static synchronized void pasteElementsWithCommand(Resource targetDiagram, double x, double y, Command command) throws Exception {
        if (source != null && source.getDiagram() != targetDiagram) {
            ElementCopyPaster target = new ElementCopyPaster(targetDiagram);
            try {
                target.pasteElementsInternal(x, y, command);
            }
            finally {
                target.dispose();
            }
        } else {
            source.pasteElementsInternal(x, y, command);
        }
    }
}

