/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.content;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceAsyncRead;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.content.RouteGraphConnectionPartData;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.ErrorHandler;

public class RouteGraphConnectionPartRequest
extends ResourceAsyncRead<RouteGraphConnectionPartData> {
    final ErrorHandler errorHandler;
    final DiagramResource DIA;

    public RouteGraphConnectionPartRequest(ErrorHandler errorHandler, DiagramResource dia, Resource resource) {
        super(resource);
        this.errorHandler = errorHandler;
        this.DIA = dia;
    }

    public void perform(AsyncReadGraph graph, final AsyncProcedure<RouteGraphConnectionPartData> procedure) {
        final AtomicInteger ready = new AtomicInteger(3);
        final RouteGraphConnectionPartData result = new RouteGraphConnectionPartData();
        final HashSet<EdgeResource> connectorLinks = new HashSet<EdgeResource>();
        final HashSet routeLinks = new HashSet();
        result.links = connectorLinks;
        result.routeLines = new ConcurrentLinkedQueue<Resource>();
        result.routePoints = new ConcurrentLinkedQueue<Resource>();
        AsyncMultiProcedure<Resource> locationProcedure = new AsyncMultiProcedure<Resource>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                RouteGraphConnectionPartRequest.this.errorHandler.error("forEachObject(connection, Has I/O) failure", throwable);
            }

            public void execute(AsyncReadGraph graph, final Resource location) {
                ready.incrementAndGet();
                graph.forEachObject(location, RouteGraphConnectionPartRequest.this.DIA.AreConnected, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        (this).RouteGraphConnectionPartRequest.this.errorHandler.error("forEachObject(:I/O Connector, Are Connected) failure", throwable);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(AsyncReadGraph graph, Resource connectedTo) {
                        HashSet hashSet = connectorLinks;
                        synchronized (hashSet) {
                            connectorLinks.add(new EdgeResource(location, connectedTo));
                        }
                    }

                    public void finished(AsyncReadGraph graph) {
                        if (ready.decrementAndGet() == 0) {
                            connectorLinks.addAll(routeLinks);
                            procedure.execute(graph, (Object)result);
                        }
                    }
                });
            }

            public void finished(AsyncReadGraph graph) {
                if (ready.decrementAndGet() == 0) {
                    connectorLinks.addAll(routeLinks);
                    procedure.execute(graph, (Object)result);
                }
            }
        };
        AsyncMultiProcedure<Resource> locationProcedure2 = new AsyncMultiProcedure<Resource>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                RouteGraphConnectionPartRequest.this.errorHandler.error("forEachObject(connection, Has Branch Point) failure", throwable);
            }

            public void execute(AsyncReadGraph graph, final Resource location) {
                ready.incrementAndGet();
                graph.forTypes(location, (AsyncProcedure)new AsyncProcedure<Set<Resource>>(){

                    public void execute(AsyncReadGraph graph, Set<Resource> types) {
                        if (types.contains((this).RouteGraphConnectionPartRequest.this.DIA.RouteLine)) {
                            result.routeLines.add(location);
                        } else if (types.contains((this).RouteGraphConnectionPartRequest.this.DIA.RoutePoint)) {
                            result.routePoints.add(location);
                        } else {
                            (this).RouteGraphConnectionPartRequest.this.errorHandler.error("unrecognized interior route node: " + String.valueOf(location), new Exception("trace"));
                        }
                        graph.forEachObject(location, (this).RouteGraphConnectionPartRequest.this.DIA.AreConnected, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                ((this).this).RouteGraphConnectionPartRequest.this.errorHandler.error("forEachObject(:Branch Point, Are Connected) failure", throwable);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void execute(AsyncReadGraph graph, Resource connectedTo) {
                                HashSet hashSet = routeLinks;
                                synchronized (hashSet) {
                                    routeLinks.add(new EdgeResource(location, connectedTo));
                                }
                            }

                            public void finished(AsyncReadGraph graph) {
                                if (ready.decrementAndGet() == 0) {
                                    connectorLinks.addAll(routeLinks);
                                    procedure.execute(graph, (Object)result);
                                }
                            }
                        });
                    }

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        (this).RouteGraphConnectionPartRequest.this.errorHandler.error("forEachObject(:Branch Point, Are Connected) failure", throwable);
                    }
                });
            }

            public void finished(AsyncReadGraph graph) {
                if (ready.decrementAndGet() == 0) {
                    connectorLinks.addAll(routeLinks);
                    procedure.execute(graph, (Object)result);
                }
            }
        };
        AsyncMultiProcedure<Resource> locationProcedure3 = new AsyncMultiProcedure<Resource>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                RouteGraphConnectionPartRequest.this.errorHandler.error("forEachObject(connection, Has I/O) failure", throwable);
            }

            public void execute(AsyncReadGraph graph, final Resource location) {
                ready.incrementAndGet();
                graph.forEachObject(location, RouteGraphConnectionPartRequest.this.DIA.AreConnected, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        (this).RouteGraphConnectionPartRequest.this.errorHandler.error("forEachObject(:I/O Connector, Are Connected) failure", throwable);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(AsyncReadGraph graph, Resource connectedTo) {
                        HashSet hashSet = connectorLinks;
                        synchronized (hashSet) {
                            connectorLinks.add(new EdgeResource(connectedTo, location));
                        }
                    }

                    public void finished(AsyncReadGraph graph) {
                        if (ready.decrementAndGet() == 0) {
                            connectorLinks.addAll(routeLinks);
                            procedure.execute(graph, (Object)result);
                        }
                    }
                });
            }

            public void finished(AsyncReadGraph graph) {
                if (ready.decrementAndGet() == 0) {
                    connectorLinks.addAll(routeLinks);
                    procedure.execute(graph, (Object)result);
                }
            }
        };
        graph.forEachObject(this.resource, this.DIA.HasPlainConnector, (AsyncMultiProcedure)locationProcedure);
        graph.forEachObject(this.resource, this.DIA.HasInteriorRouteNode, (AsyncMultiProcedure)locationProcedure2);
        graph.forEachObject(this.resource, this.DIA.HasArrowConnector, (AsyncMultiProcedure)locationProcedure3);
    }
}

