/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.content;

import java.util.EnumSet;
import java.util.StringTokenizer;
import org.simantics.g2d.connection.EdgeVisualsConfigurer;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;

public class ArrowConfigurer
implements EdgeVisualsConfigurer {
    private EdgeVisuals.ArrowType arrow = EdgeVisuals.ArrowType.None;
    private double arrowSize = 1.0;

    public ArrowConfigurer() {
    }

    public ArrowConfigurer(EdgeVisuals.ArrowType arrow, double arrowSize) {
        this.arrow = arrow;
        this.arrowSize = arrowSize;
    }

    public ArrowConfigurer(String description) {
        StringTokenizer tokenizer = new StringTokenizer(description);
        if (tokenizer.hasMoreTokens()) {
            String type = tokenizer.nextToken();
            this.arrow = this.parseType(type);
        }
        if (tokenizer.hasMoreTokens()) {
            String size = tokenizer.nextToken();
            this.arrowSize = this.parseSize(size);
        }
    }

    private double parseSize(String size) {
        try {
            return Double.parseDouble(size);
        }
        catch (NumberFormatException numberFormatException) {
            return 1.0;
        }
    }

    private EdgeVisuals.ArrowType parseType(String type) {
        String lower = type.toLowerCase();
        if ("none".equals(lower)) {
            return EdgeVisuals.ArrowType.None;
        }
        if ("stroke".equals(lower)) {
            return EdgeVisuals.ArrowType.Stroke;
        }
        if ("fill".equals(lower)) {
            return EdgeVisuals.ArrowType.Fill;
        }
        if ("both".equals(lower)) {
            return EdgeVisuals.ArrowType.Both;
        }
        throw new IllegalArgumentException("unrecognized arrow type: " + type);
    }

    public void configure(IElement edge, EdgeVisuals visuals, EnumSet<EdgeVisuals.EdgeEnd> ends) {
        for (EdgeVisuals.EdgeEnd end : ends) {
            visuals.setArrowType(edge, end, this.arrow);
            visuals.setArrowSize(edge, end, this.arrowSize);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.arrow) + " " + this.arrowSize + "]";
    }
}

