/*******************************************************************************
 * Copyright (c) 2013, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbolcontribution;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 */
public interface SymbolContributionFilter {

	/**
	 * @param graph        database handle
	 * @param contribution the filtered contribution resource
	 * @param filter       the resource corresponding to this executed filter
	 * @param diagram      the diagram for which the contribution filtering is
	 *                     performed. This may be <code>null</code> if the system is
	 *                     computing symbol contributions without a diagram editor
	 *                     or diagram.
	 * @return <code>true</code> if the provided contribution should be accepted,
	 *         <code>false</code> if it should be rejected.
	 * @throws DatabaseException
	 */
	boolean accept(ReadGraph graph, Resource contribution, Resource filter, Resource diagram) throws DatabaseException;

}
