package org.simantics.diagram.profile;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.Binding;

/**
 * @author Tuukka Lehtonen
 * @since 1.32.0
 */
public class ProfileActivityBean {

	public static final String EXTENSION_KEY = ProfileActivityBean.class.getSimpleName();
	public static final Binding BINDING = Bindings.getBindingUnchecked(ProfileActivityBean.class);

	public static class Profile {
		public String relativeUri;
		public List<String> activeEntries = new ArrayList<>();
	}

	public TreeMap<String, Profile> topLevelProfiles = new TreeMap<>();

	@Optional
	public String activeProfile;

}
