package org.simantics.diagram.profile;

import java.awt.geom.AffineTransform;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.utils.datastructures.map.Tuple;

public class ButtonResult extends Tuple implements IconButtonResult {
	
    public static class B extends Bean implements IconButtonConfiguration {
    	private static final Binding BINDING = Bindings.getBindingUnchecked(B.class);
    	public String id;
    	public int index;
    	@Optional
    	public Vec2d offset;
    	public Vec2d size;
    	public boolean relativeTransform;
    	public ButtonMode mode;
    	public B(String id, int index, Vec2d offset, Vec2d size, boolean relativeTransform, ButtonMode mode) {
    		super(BINDING);
    		this.id = id;
    		this.index = index;
    		this.offset = offset;
    		this.size = size;
    		this.relativeTransform = relativeTransform;
    		this.mode = mode;
    	}
		@Override
		public Vec2d getOffset() {
			return offset;
		}
		@Override
		public String getId() {
			return id;
		}
		@Override
		public Vec2d getSize() {
			return size;
		}
		@Override
		public int getIndex() {
			return index;
		}
		@Override
		public boolean getRelativeTransform() {
			return relativeTransform;
		}
    }
    public static class A extends Bean implements IconButtonState {
    	private static final Binding BINDING = Bindings.getBindingUnchecked(A.class);
    	public double value;
    	public B config;
    	public A(double value, B config) {
    		super(BINDING);
    		this.value = value;
    		this.config = config;
    	}
		@Override
		public IconButtonConfiguration getConfiguration() {
			return config;
		}
    }
    public ButtonResult(A a, Variable property, Function1<Boolean, Boolean> pressed, AffineTransform transform) {
        super(a, property, pressed, transform);
    }
    public A getA() {
        return (A) getField(0);
    }
    public Variable getProperty() {
    	return (Variable) getField(1);
    }
    @SuppressWarnings("unchecked")
    public Function1<Boolean, Boolean> getPressed() {
    	return (Function1<Boolean, Boolean>) getField(2);
    }
    public AffineTransform getParentTransform() {
    	return (AffineTransform) getField(3);
    }
    public ButtonResult withValue(double value) {
    	return new ButtonResult(new A(value, getA().config), getProperty(), getPressed(), getParentTransform());
    }
	@Override
	public IconButtonState getState() {
		return getA();
	}
}