/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.flag;

import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

import org.simantics.diagram.flag.IFlagType.FlagInfo;
import org.simantics.g2d.elementclass.FlagClass.Type;
import org.simantics.g2d.utils.Alignment;

/**
 * A builder for {@link FlagInfoImpl} instances.
 * 
 * @author Tuukka Lehtonen
 */
public class FlagInfoBuilder {

    private static final String[] NO_TEXT = {};

    private Shape       shape;
    private String[]    text = NO_TEXT;
    private Type        type;
    private Rectangle2D textArea;
    private Alignment   horizontalAlignment = Alignment.LEADING;
    private Alignment   verticalAlignment = Alignment.CENTER;
    private Font        font;

    public static FlagInfoBuilder fill(Type type) {
        return new FlagInfoBuilder().type(type);
    }

    public FlagInfoBuilder() {
    }

    public FlagInfo create() {
        return new FlagInfoImpl(shape, text, type, textArea, horizontalAlignment, verticalAlignment, font);
    }

    public Shape shape() {
        return shape;
    }

    public String[] text() {
        return text;
    }

    public Font font() {
        return font;
    }
    
    public Type type() {
        return type;
    }

    public Rectangle2D textArea() {
        return textArea;
    }

    public Alignment horizontalAlignment() {
        return horizontalAlignment;
    }

    public Alignment verticalAlignment() {
        return verticalAlignment;
    }

    public FlagInfoBuilder shape(Shape shape) {
        this.shape = shape;
        return this;
    }

    public FlagInfoBuilder text(String[] text) {
        this.text = text;
        return this;
    }
    
    public FlagInfoBuilder font(Font font) {
        this.font = font;
        return this;
    }

    public FlagInfoBuilder type(Type type) {
        this.type = type;
        return this;
    }

    public FlagInfoBuilder textArea(Rectangle2D textArea) {
        this.textArea = textArea;
        return this;
    }

    public FlagInfoBuilder horizontalAlignment(Alignment align) {
        this.horizontalAlignment = align;
        return this;
    }

    public FlagInfoBuilder verticalAlignment(Alignment align) {
        this.verticalAlignment = align;
        return this;
    }

}
