/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.elements;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

import org.simantics.g2d.scenegraph.SceneGraphConstants;
import org.simantics.scenegraph.ILookupService;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.nodes.DataNode;
import org.simantics.scenegraph.utils.NodeUtil;

/**
 * @author Tuukka Lehtonen
 */
public class EditDataNode extends G2DNode {

    /**
     * Used for naming and identifying (see {@link #setLookupId(String)})
     * GridNode instances in scene graphs.
     */
    public static final String           NODE_ID          = "edit";

    private static final long            serialVersionUID = -6446582030817143221L;

    private transient TextEditActivation activation;

    @Override
    public void init() {
        setLookupId(NODE_ID);
    }

    public void setTextEditActivation(TextEditActivation a) {
        this.activation = a;
    }

    public TextEditActivation getTextEditActivation() {
        return activation;
    }

    @Override
    public void render(Graphics2D g2d) {
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    public static EditDataNode getNode(INode node) {
        return getEditDataNode( NodeUtil.getLookupService(node) );
    }

    public static EditDataNode getEditDataNode(ILookupService lookup) {
        EditDataNode node = (EditDataNode) lookup.lookupNode(EditDataNode.NODE_ID);
        if (node == null) {
            DataNode data = (DataNode) lookup.lookupNode(SceneGraphConstants.DATA_NODE_NAME);
            if (data == null)
                throw new IllegalStateException("No '" + SceneGraphConstants.DATA_NODE_NAME + "' node in lookup " + lookup);
            node = data.getOrCreateNode(EditDataNode.NODE_ID, EditDataNode.class);
            node.setLookupId(EditDataNode.NODE_ID);
        }
        return node;
    }

}
