/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.content;

/**
 * @author Tuukka Lehtonen
 *
 * @param <T> a comparable type
 */
public class OrderedPair<T extends Comparable<T>> {

    private final T first;
    private final T second;

    public OrderedPair(T first, T second) {
        assert first != null;
        assert second != null;

        int comp = first.compareTo(second);
        if (comp < 0) {
            this.first = first;
            this.second = second;
        } else {
            this.first = second;
            this.second = first;
        }
    }

    public T first() {
        return first;
    }

    public T second() {
        return second;
    }

    @Override
    public int hashCode() {
        return (first.hashCode() * 31) + second.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (!(obj instanceof OrderedPair<?>))
            return false;
        OrderedPair<?> other = (OrderedPair<?>) obj;
        return first.equals(other.first) && second.equals(other.second);
    }

    public static <T extends Comparable<T>> OrderedPair<T> make(T ra, T rb) {
        return new OrderedPair<T>(ra, rb);
    }

}