/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import java.util.concurrent.atomic.AtomicBoolean;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.simantics.g2d.canvas.ICanvasContext;

/**
 * @author Tuukka Lehtonen
 */
public class CanvasAdapterFactory implements IAdapterFactory {

    /**
     * Hack for preventing eternal {@link #getAdapter(Object, Class)} recursion
     */
    AtomicBoolean adapting = new AtomicBoolean(false);

    @SuppressWarnings("rawtypes")
    @Override
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (!adapting.compareAndSet(false, true)) {
            return null;
        }
        try {
            if (ICanvasContext.class.equals(adapterType)) {
                if (adaptableObject instanceof IAdaptable) {
                    return ((IAdaptable) adaptableObject).getAdapter(adapterType);
                }
            }
            return null;
        } finally {
            adapting.set(false);
        }
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Class[] getAdapterList() {
        return new Class[] { ICanvasContext.class };
    }

}
