/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection.rendering;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.io.Serializable;

public class ExampleConnectionStyle implements ConnectionStyle, Serializable {

    private static final long serialVersionUID = -5799681720482456895L;

    public final static BasicStroke SOLID = 
            new BasicStroke(1f); 
    
    public final static BasicStroke BOLD = 
            new BasicStroke(3f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_BEVEL); 
    
	@Override
	public void drawLine(Graphics2D g, double x1, double y1, double x2,
			double y2, boolean isTransient) {
		g.setColor(Color.BLACK);
		if(isTransient)
			g.draw(new Line2D.Double(x1, y1, x2, y2));
		else {
			g.setStroke(BOLD);
			g.draw(new Line2D.Double(x1, y1, x2, y2));
			g.setStroke(SOLID);
		}
	}

	@Override
	public void drawPath(Graphics2D g, Path2D path, boolean isTransient) {
	    g.setColor(Color.BLACK);
	    if(isTransient)
	        g.draw(path);
	    else {
	        g.setStroke(BOLD);
	        g.draw(path);
	        g.setStroke(SOLID);
	    }
	}

	@Override
	public void drawBranchPoint(Graphics2D g, double x, double y) {
		g.setColor(Color.BLACK);
		g.fill(new Ellipse2D.Double(x-3, y-3, 6, 6));		
	}

	@Override
	public void drawDegeneratedLine(Graphics2D g, double x, double y,
			boolean isHorizontal, boolean isTransient) {
		double d = getDegeneratedLineLength()*0.5;
		if(isHorizontal)
			g.draw(new Line2D.Double(x-d, y, x+d, y));
		else
			g.draw(new Line2D.Double(x, y-d, x, y+d));
	}

	@Override
	public double getDegeneratedLineLength() {
		return 8.0;
	}

}
