/*******************************************************************************
 * Copyright (c) 2020 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection.rendering;

import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AggregateConnectionStyle implements ConnectionStyle, Serializable{

    private static final long serialVersionUID = 5888959070127628457L;
    private List<ConnectionStyle> styles = new ArrayList<>();
    
    public void addStyle(ConnectionStyle style) {
        styles.add(style);
    }
    
    @Override
    public void drawBranchPoint(Graphics2D g, double x, double y) {
        for (ConnectionStyle style : styles) {
            style.drawBranchPoint(g, x, y);
        }
    }

    @Override
    public void drawLine(Graphics2D g, double x1, double y1, double x2, double y2, boolean isTransient) {
        for (ConnectionStyle style : styles) {
            style.drawLine(g, x1, y1, x2, y2, isTransient);
        }
    }

    @Override
    public void drawPath(Graphics2D g, Path2D path, boolean isTransient) {
        for (ConnectionStyle style : styles) {
            style.drawPath(g, path, isTransient);
        }
    }

    @Override
    public void drawDegeneratedLine(Graphics2D g, double x, double y, boolean isHorizontal, boolean isTransient) {
        for (ConnectionStyle style : styles) {
            style.drawDegeneratedLine(g, x, y, isHorizontal, isTransient);
        }
    }

    @Override
    public double getDegeneratedLineLength() {
        double max = 0;
        for (ConnectionStyle style : styles) {
            max = Math.max(max, style.getDegeneratedLineLength());
        }
        return max;
    }

}
