/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection.actions;

import gnu.trove.map.hash.THashMap;

import java.awt.Graphics2D;

import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteLineHalf;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;

public class ReconnectLineAction implements IReconnectAction {

    RouteGraph rg;
    RouteGraph rgc;
    RouteLine line;

    public ReconnectLineAction(RouteGraph rg, RouteGraph rgc, RouteLine line) {
        this.rg = rg;
        this.rgc = rgc;
        this.line = line;
    }

    @Override
    public void render(Graphics2D g, IRouteGraphRenderer renderer, double mouseX, double mouseY) {
        THashMap<Object, Object> map = new THashMap<Object, Object>();
        RouteGraph rgc = this.rgc.copy(map);  
        RouteLine sLine = (RouteLine)map.get(line);
        if(!rgc.connectLine(sLine, mouseX, mouseY, TOLERANCE) || !rgc.isTree()) {
            map.clear();
            rgc = this.rgc.copy(map);
            sLine = (RouteLine)map.get(line);
            RouteTerminal t2 = rgc.addTerminal(mouseX, mouseY, 
                    mouseX, mouseY,
                    mouseX, mouseY, 15);
            rgc.link(sLine, t2);
        }
        renderer.render(g, rgc);  
    }

    @Override
    public void finish(double x, double y) {
        if(rgc.connectLine(line, x, y, TOLERANCE) && rgc.isTree()) {
            rgc.removeExtraConnections();
            rg.replaceBy(rgc);
        }
    }

    public static IAction create(RouteGraph rg, double x, double y) {
        RouteGraph rgc = rg.copy();
        RouteLineHalf lh = rgc.pickLineHalf(x, y, TOLERANCE);
        if(lh == null)
            return null;
        RouteLine line = lh.getLine();
        if(line.isTransient()) {
            RouteTerminal terminal = line.getTerminal();
            rgc.disconnect(terminal);
            return new ReconnectTerminalAction(rg, rgc, terminal);
        }
        else {
            rgc.makePersistent(line);
            rgc.remove(lh.getLink());
            return new ReconnectLineAction(rg, rgc, line);
        }
    }

}
