/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     THTH ry - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.browser.sections;

import java.io.PrintWriter;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Jani Simomaa / Semantum Oy
 * @since 1.22
 */
public class ResourceLookupSection implements ResourceBrowserSection {

    @Override
    public double getPriority() {
        return -1;
    }

    @Override
    public void toHtml(ReadGraph graph, PrintWriter out) throws DatabaseException {
        out.println("<div class=\"resourceLookupSection\">");
        out.println("<form class=\"resource-search\" method=\"POST\">");
        out.println("<input type=\"text\" name=\"resource-input\" placeholder=\"Enter resource URI or ID\" />");
        out.println("<button type=\"submit\">Search</button>");
        out.println("</form>");
        out.println("</div>");
    }

}
