/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     THTH ry - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.browser.content;

import gnu.trove.map.hash.THashMap;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.browser.sections.ResourceBrowserSection;

public class ResourceBrowserContent {
    public final Resource resource;
    private final THashMap<Class<?>, ResourceBrowserSection> sectionMap =
            new THashMap<Class<?>, ResourceBrowserSection>();
    
    private ResourceBrowserContent(Resource resource) {
        this.resource = resource;
    }
    
    @SuppressWarnings("unchecked")
    public <T extends ResourceBrowserSection> T getSection(Class<T> clazz) {
        return (T)sectionMap.get(clazz);
    }
    
    public <T extends ResourceBrowserSection> void putSection(Class<T> clazz, T section) {
        sectionMap.put(clazz, section);
    }
    
    @SuppressWarnings("unchecked")
    public <T extends ResourceBrowserSection> T removeSection(Class<T> clazz) {
        return (T)sectionMap.remove(clazz);
    }
    
    private static final Comparator<ResourceBrowserSection> SECTION_COMPARATOR = new Comparator<ResourceBrowserSection>() {
        @Override
        public int compare(ResourceBrowserSection o1, ResourceBrowserSection o2) {
            return Double.compare(o1.getPriority(), o2.getPriority());
        }
    };
    
    public void toHtml(ReadGraph graph, PrintWriter stream) throws DatabaseException {
        ArrayList<ResourceBrowserSection> sections = new ArrayList<ResourceBrowserSection>(sectionMap.values());
        Collections.sort(sections, SECTION_COMPARATOR);
        for(ResourceBrowserSection section : sections)
            section.toHtml(graph, stream);
    }
    
    public static ResourceBrowserContent createContentFor(ReadGraph graph, Resource resource) throws DatabaseException {
        ResourceBrowserContent content = new ResourceBrowserContent(resource);
        for(ResourceBrowserRewriter rewriter : ResourceBrowserRewriterRepository.getRewriters())
            rewriter.rewrite(graph, content);
        return content;
    }
}