/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.testing.common;

import java.io.File;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.request.ActivateModel;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.TransferableGraphFileReader;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class TestingUtils {
    public static Resource importModel(final Resource toLocation, File fromFile, String withName) throws Exception {
        TransferableGraph1 tg = TransferableGraphFileReader.read((File)fromFile);
        final DefaultPasteImportAdvisor advisor = new DefaultPasteImportAdvisor(toLocation){

            public void analyzeType(ReadGraph graph, Root root) throws DatabaseException {
                Resource typeResource = graph.getResource(root.type);
                if (graph.isInheritedFrom(typeResource, SimulationResource.getInstance((ReadGraph)graph).Model)) {
                    this.library = toLocation;
                }
            }
        };
        TransferableGraphs.importGraph1((Session)Simantics.getSession(), (TransferableGraph1)tg, (IImportAdvisor)advisor, null);
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                String name = (String)graph.getPossibleRelatedValue(advisor.getRoot(), L0.HasName);
                if (name != null) {
                    graph.claimLiteral(advisor.getRoot(), L0.HasLabel, (Object)name);
                }
                graph.syncRequest((WriteResult)new ActivateModel(toLocation, advisor.getRoot()));
            }
        });
        return advisor.getRoot();
    }

    public static Resource getResource(final Resource base, final String suffix) throws DatabaseException {
        return (Resource)Simantics.getSession().syncRequest((Read)new Read<Resource>(){

            public Resource perform(ReadGraph graph) throws DatabaseException {
                String baseURI = graph.getURI(base);
                return graph.getResource(baseURI + suffix);
            }
        });
    }

    public static double readConfiguration(Resource model, String rvi) throws DatabaseException {
        class ReadConfiguration
        extends BinaryRead<Resource, String, Double> {
            public ReadConfiguration(Resource model, String rvi) {
                super((Object)model, (Object)rvi);
            }

            public Double perform(ReadGraph graph) throws DatabaseException {
                Variable state = Variables.getVariable((ReadGraph)graph, (String)(graph.getURI((Resource)this.parameter) + (String)this.parameter2));
                float result = ((Float)state.getValue(graph)).floatValue();
                return result;
            }
        }
        return (Double)Simantics.getSession().syncRequest((Read)new ReadConfiguration(model, rvi));
    }

    public static double readState(Resource run, String rvi) throws DatabaseException {
        class ReadState
        extends BinaryRead<Resource, String, Double> {
            public ReadState(Resource run, String rvi) {
                super((Object)run, (Object)rvi);
            }

            public Double perform(ReadGraph graph) throws DatabaseException {
                Variable state = Variables.getVariable((ReadGraph)graph, (String)(graph.getURI((Resource)this.parameter) + (String)this.parameter2));
                float result = ((Float)state.getValue(graph)).floatValue();
                return result;
            }
        }
        return (Double)Simantics.getSession().syncRequest((Read)new ReadState(run, rvi));
    }

    public static boolean lineEquals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static String compare(String s1, String s2) {
        if (s1.equals(s2)) {
            return null;
        }
        String[] lines1 = s1.split("\n");
        String[] lines2 = s2.split("\n");
        int i = 0;
        while (i < Math.max(lines1.length, lines2.length)) {
            String t2;
            String t1 = i < lines1.length ? lines1[i] : null;
            String string = t2 = i < lines2.length ? lines2[i] : null;
            if (!TestingUtils.lineEquals(t1, t2)) {
                return "Difference at line " + (i + 1) + ": '" + t1 + "' vs. '" + t2 + "'";
            }
            ++i;
        }
        return null;
    }
}

