/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.testing.base;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.junit.Assert;
import org.simantics.db.testing.cases.FreshWorkspaceTest;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.commands.TestScriptExecutor;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.utils.FileUtils;

public class ScriptTestBase
extends FreshWorkspaceTest {
    String path;

    public ScriptTestBase(String path) {
        this.path = path;
    }

    protected void test() {
        String testPath = this.getTestPath();
        this.test(0, testPath);
    }

    protected void test(int allowedExecutionTime) {
        String testPath = this.getTestPath();
        this.test(allowedExecutionTime, testPath);
    }

    protected void test(int allowedExecutionTime, String testPath) {
        if (allowedExecutionTime > 0) {
            Timer timer = new Timer();
            try {
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            String workingDir = System.getProperty("user.dir");
                            Location location = Platform.getInstanceLocation();
                            String workspacePath = location.getURL().getPath().substring(1);
                            String[] pathToWorkspace = workspacePath.split("/");
                            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyy_HH.mm.ss");
                            String date = sdf.format(new Date());
                            String zipDir = workingDir + "/" + pathToWorkspace[pathToWorkspace.length - 1] + "_" + date + ".zip";
                            FileUtils.compressZip((String)workspacePath, (String)zipDir);
                            String processName = ManagementFactory.getRuntimeMXBean().getName();
                            System.out.println("PID: " + processName);
                            String PID = processName.split("@")[0];
                            String command = "taskkill /F /PID " + PID;
                            System.out.println("Command: " + command);
                            Runtime.getRuntime().exec(command);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            System.err.println(ioe);
                        }
                    }
                }, 1000 * allowedExecutionTime);
                this.testImpl(testPath);
            }
            finally {
                timer.cancel();
            }
        } else {
            this.testImpl(testPath);
        }
    }

    protected void testImpl(String testPath) {
        System.out.println("Testing script: " + testPath);
        InputStream stream = this.getClass().getResourceAsStream(testPath);
        if (stream == null) {
            Assert.fail((String)("Didn't find " + testPath + " at " + String.valueOf(this.getClass().getResource(""))));
        }
        try {
            try {
                CommandSession session = new CommandSession(SCLOsgi.MODULE_REPOSITORY, null);
                TestScriptExecutor executor = new TestScriptExecutor(session, new BufferedReader(new InputStreamReader(stream)), null);
                executor.execute();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
    }

    public String getTestPath() {
        String methodName = new Exception().getStackTrace()[2].getMethodName();
        String testPath = this.path + "/" + methodName + ".sts";
        return testPath;
    }

    public void isDBLogClean() throws IOException {
        String workingDir = System.getProperty("user.dir");
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new FileReader(workingDir + "/db-client.log"));){
            Assert.assertEquals((Object)br.readLine(), null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

