/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.testing.base;

import gnu.trove.list.array.TLongArrayList;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.junit.Test;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.testing.base.AllowedThrowable;
import org.simantics.db.testing.cases.FreshDatabaseTest;
import org.simantics.db.testing.common.Command;
import org.simantics.db.testing.common.CommandSequenceEnvironment;
import org.simantics.db.testing.common.CommandSpec;

public abstract class CommandSequenceTest
extends FreshDatabaseTest
implements CommandSequenceEnvironment {
    private static final boolean TRACE = true;
    protected TLongArrayList executionTimes = new TLongArrayList();

    protected double getSlowdown() {
        SimpleRegression regression = new SimpleRegression();
        int i = 0;
        while (i < this.executionTimes.size()) {
            regression.addData((double)i, (double)this.executionTimes.getQuick(i));
            ++i;
        }
        double intercept = regression.getIntercept();
        double slope = regression.getSlope();
        return slope * (double)this.executionTimes.size() / Math.abs(intercept);
    }

    protected String getExecutionData() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.executionTimes.size()) {
            b.append(this.executionTimes.get(i) + "\n");
            ++i;
        }
        return b.toString();
    }

    protected void printExecutionTimes() {
        int i = 0;
        while (i < this.executionTimes.size()) {
            System.err.println(i + ": " + this.executionTimes.getQuick(i));
            ++i;
        }
    }

    protected void assertSlowdown(double slowdown) {
        this.assertLess(this.getSlowdown(), 0.1, this.getExecutionData());
    }

    protected int getSequenceSize() {
        return 0;
    }

    protected Command[] beforeSequence(CommandSequenceEnvironment environment) throws Exception {
        return new Command[0];
    }

    protected Command[] afterSequence(CommandSequenceEnvironment environment) throws Exception {
        return new Command[0];
    }

    protected CommandSpec<?>[] getFactories() {
        return null;
    }

    @Override
    public Session getSession() {
        return super.getSession();
    }

    public int randomNatural() {
        return (int)(Math.random() * 2.147483647E9);
    }

    protected Command[] newSequence() throws Exception {
        int size = this.getSequenceSize();
        CommandSpec<?>[] classes = this.getFactories();
        int index = 0;
        Command[] result = new Command[size];
        double totalWeight = 0.0;
        CommandSpec<?>[] commandSpecArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            CommandSpec<?> p = commandSpecArray[n2];
            totalWeight += p.weight;
            ++n2;
        }
        double[] wts = new double[classes.length];
        index = 0;
        double previous = 0.0;
        CommandSpec<?>[] commandSpecArray2 = classes;
        int n3 = classes.length;
        int n4 = 0;
        while (n4 < n3) {
            CommandSpec<?> p = commandSpecArray2[n4];
            double weight = p.weight / totalWeight;
            wts[index++] = previous + weight;
            previous += weight;
            ++n4;
        }
        int i = 0;
        while (i < size) {
            double n5 = Math.random();
            int j = 0;
            while (j < classes.length) {
                if (n5 < wts[j]) {
                    result[i] = (Command)((Object)classes[j].clazz.newInstance());
                    break;
                }
                if (j == result.length - 1) {
                    result[i] = (Command)((Object)classes[result.length - 1].clazz.newInstance());
                    break;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    protected CommandSequenceEnvironment createEnvironment() {
        return this;
    }

    protected void initialize(CommandSequenceEnvironment environment) throws Exception {
    }

    protected void analyse(CommandSequenceEnvironment environment) throws Exception {
    }

    @Test
    public void test() throws Exception {
        Command command;
        Command[] sequence;
        CommandSequenceEnvironment environment = this.createEnvironment();
        this.initialize(environment);
        Command[] commandArray = this.beforeSequence(environment);
        int n = commandArray.length;
        int n2 = 0;
        while (n2 < n) {
            Command command2 = commandArray[n2];
            command2.run(environment);
            ++n2;
        }
        int counter = 0;
        int lastProgress = 0;
        Command[] commandArray2 = sequence = this.newSequence();
        int n3 = sequence.length;
        int n4 = 0;
        while (n4 < n3) {
            long start;
            block6: {
                command = commandArray2[n4];
                System.err.println("[" + counter + "/" + sequence.length + "]: " + ((Object)((Object)command)).getClass().getSimpleName());
                start = System.nanoTime();
                try {
                    command.run(environment);
                }
                catch (Throwable t) {
                    if (this.isAllowed(t)) break block6;
                    throw new AssertionError((Object)t);
                }
            }
            long duration = System.nanoTime() - start;
            this.executionTimes.add(duration);
            int progress = 100 * counter++ / sequence.length;
            if (progress > lastProgress) {
                System.err.println("[" + counter + "/" + sequence.length + "]: " + progress + "%");
                lastProgress = progress;
            }
            ++n4;
        }
        commandArray2 = this.afterSequence(environment);
        n3 = commandArray2.length;
        n4 = 0;
        while (n4 < n3) {
            command = commandArray2[n4];
            command.run(environment);
            ++n4;
        }
        this.analyse(environment);
    }

    @Override
    public void invoke(CommandSequenceEnvironment environment, Command command) {
        block2: {
            try {
                command.run(environment);
            }
            catch (Throwable t) {
                if (this.isAllowed(t)) break block2;
                throw new AssertionError((Object)t);
            }
        }
    }

    boolean isAllowed(Throwable t) {
        DatabaseException d;
        if (t instanceof AllowedThrowable) {
            return true;
        }
        return t instanceof DatabaseException && (d = (DatabaseException)t).getCause() instanceof AllowedThrowable;
    }
}

