/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - improvements
 *******************************************************************************/
package org.simantics.db.service;

import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;


/**
 * @author Antti Villberg
 */
public interface ClusteringSupport {

    /**
     * TODO: specify thread-safety
     * 
     * @return id of new cluster
     */
    long createCluster();

    long getCluster(Resource r);
    
    int getNumberOfResources(long clusterId) throws DatabaseException;
    int maximumClusterSize();
    
    Resource getResourceByKey(int resourceKey) throws ResourceNotFoundException;
    
    Resource getResourceByIndexAndCluster(int resourceIndex, long clusterId)
    throws DatabaseException, ResourceNotFoundException;
    interface Id {
        long[] toLong();
    }
    
    boolean isClusterSet(Resource r) throws DatabaseException;
    Resource getClusterSetOfCluster(Resource r) throws DatabaseException;
    Resource getClusterSetOfCluster(long cluster) throws DatabaseException;
    
}
