package org.simantics.db.request;

import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.procedure.SyncProcedure;

/**
 * 
 * An interface representing a computation of a single result. Some standard implementations of ReadInterface and WriteInterface include
 * <ul>
 * <li>{@link ResourceRead} which is identified by a single resource
 * <li>{@link ResourceRead2} which is identified by a pair of resources
 * <li>{@link UnaryRead} which is identifier by a single object
 * <li>{@link BinaryRead} which is identifier by a pair of objects
 * <li>{@link UniqueRead} which is unique (not equal to anything but itself)
 * <li>{@link ReadRequest} which does not report a result
 * </ul>
 * <p>
 * 
 * The client is not expected to implement this class but rather to extend one of the standard implementations.
 * 
 * @version 1.5
 * @author Antti Villberg
 * @see WriteInterface
 * @see RequestProcessor
 * @see ReadGraph
 * @see Session
 */

public interface ReadInterface<Result> {

	Result request(RequestProcessor processor) throws DatabaseException;
	void request(AsyncRequestProcessor processor, AsyncProcedure<Result> procedure);
	void request(AsyncRequestProcessor processor, Procedure<Result> procedure);
	void request(AsyncRequestProcessor processor, SyncProcedure<Result> procedure);
	void request(AsyncRequestProcessor processor, AsyncListener<Result> procedure);
	void request(AsyncRequestProcessor processor, Listener<Result> procedure);
	void request(AsyncRequestProcessor processor, SyncListener<Result> procedure);
	
}
