/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy  - initial API and implementation
 *******************************************************************************/
package org.simantics.db.request;

import org.simantics.db.exception.DatabaseException;

public interface QueryFactory {
	
    void readEntry(QueryDeserializer deserializer) throws DatabaseException;
    void parent(QueryDeserializer deserializer) throws DatabaseException;

    default void read(QueryDeserializer deserializer) throws DatabaseException {
    	readEntry(deserializer);
    	readParents(deserializer);
    }

    default public void readParents(QueryDeserializer deserializer) throws DatabaseException {
        int ps = deserializer.readLE4();
        for(int i=0;i<ps;i++) {
            QueryFactory qf = deserializer.readFactory();
            qf.parent(deserializer);
        }
    }

}
